import React, { useEffect, useState } from 'react';
import { ErrorBoundary } from 'react-error-boundary';
import { Error } from '../Error/Error';
function fallbackRender(_a) {
    var error = _a.error;
    var ErrorObject = {
        title: 'Something went wrong',
        type: 'application-error',
        validationErrors: [
            {
                title: error === null || error === void 0 ? void 0 : error.message,
            },
        ],
    };
    return React.createElement(Error, { error: ErrorObject });
}
var AsyncApiErrorBoundary = function (_a) {
    var children = _a.children;
    var _b = useState(0), key = _b[0], setKey = _b[1];
    useEffect(function () {
        setKey(function (prevKey) { return prevKey + 1; });
    }, [children]);
    return (React.createElement(ErrorBoundary, { key: key, fallbackRender: fallbackRender }, children));
};
export default AsyncApiErrorBoundary;
//# sourceMappingURL=ErrorBoundary.js.map