/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllArgsConstructorProcessor
extends AbstractConstructorClassProcessor {
    public AllArgsConstructorProcessor() {
        super("lombok.AllArgsConstructor", PsiMethod.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(2);
        }
        boolean result = super.validate(psiAnnotation, psiClass, builder);
        Collection<PsiField> allNotInitializedNotStaticFields = AllArgsConstructorProcessor.getAllFields(psiClass);
        String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
        return result &= this.validateIsConstructorNotDefined(psiClass, staticConstructorName, allNotInitializedNotStaticFields, builder);
    }

    @NotNull
    public Collection<PsiMethod> createAllArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(3);
        }
        if (methodVisibility == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(5);
        }
        Collection<PsiField> allNotInitializedNotStaticFields = AllArgsConstructorProcessor.getAllNotInitializedAndNotStaticFields(psiClass);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodVisibility, psiAnnotation, false, allNotInitializedNotStaticFields);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(8);
        }
        if (target == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(9);
        }
        if (null != (methodVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
            target.addAll(this.createAllArgsConstructor(psiClass, methodVisibility, psiAnnotation, staticConstructorName));
        }
    }

    @NotNull
    private Collection<PsiMethod> createAllArgsConstructor(PsiClass psiClass, String methodVisibility, PsiAnnotation psiAnnotation, String staticName) {
        Collection<PsiField> allNotInitializedNotStaticFields = AllArgsConstructorProcessor.getAllFields(psiClass);
        Collection<PsiMethod> collection = this.createAllArgsConstructor(psiClass, methodVisibility, psiAnnotation, staticName, allNotInitializedNotStaticFields, false);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createAllArgsConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, String staticName, Collection<PsiField> allNotInitializedNotStaticFields, boolean skipConstructorIfAnyConstructorExists) {
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(11);
        }
        if (methodModifier == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(13);
        }
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodModifier, psiAnnotation, false, allNotInitializedNotStaticFields, staticName, skipConstructorIfAnyConstructorExists);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        boolean classAnnotatedWithValue;
        PsiClass containingClass;
        if (psiField == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(16);
        }
        if (null != (containingClass = psiField.getContainingClass()) && AllArgsConstructorProcessor.isNotInitializedAndNotStaticField(psiField, classAnnotatedWithValue = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)containingClass, "lombok.Value"))) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AllArgsConstructorProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AllArgsConstructorProcessor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAllArgsConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAllArgsConstructor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 14 -> new IllegalStateException(string);
        };
    }
}

