/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.logging;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.logging.JvmLogger;
import com.intellij.lang.logging.ProjectContainingLibrariesScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import de.plushnikov.intellij.plugin.processor.clazz.log.AbstractLogProcessor;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lde/plushnikov/intellij/plugin/logging/JvmLoggerAnnotationDelegate;", "Lcom/intellij/lang/logging/JvmLogger;", "loggerTypeName", "", "id", "annotationTypeName", "priority", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getLoggerTypeName", "()Ljava/lang/String;", "getId", "getPriority", "()I", "insertLoggerAtClass", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "clazz", "Lcom/intellij/psi/PsiClass;", "logger", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "isPossibleToPlaceLoggerAtClass", "createLogger", "Lcom/intellij/psi/PsiAnnotation;", "getLogFieldName", "intellij.lombok"})
public final class JvmLoggerAnnotationDelegate
implements JvmLogger {
    @NotNull
    private final String loggerTypeName;
    @NotNull
    private final String id;
    @NotNull
    private final String annotationTypeName;
    private final int priority;

    public JvmLoggerAnnotationDelegate(@NotNull String loggerTypeName, @NotNull String id, @NotNull String annotationTypeName, int priority) {
        Intrinsics.checkNotNullParameter((Object)loggerTypeName, (String)"loggerTypeName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)annotationTypeName, (String)"annotationTypeName");
        this.loggerTypeName = loggerTypeName;
        this.id = id;
        this.annotationTypeName = annotationTypeName;
        this.priority = priority;
    }

    @NotNull
    public String getLoggerTypeName() {
        return this.loggerTypeName;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nullable
    public PsiElement insertLoggerAtClass(@NotNull Project project, @NotNull PsiClass clazz, @NotNull PsiElement logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!(logger instanceof PsiAnnotation)) {
            return null;
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(logger);
        PsiModifierList psiModifierList = clazz.getModifierList();
        return psiModifierList != null ? psiModifierList.addAfter(logger, null) : null;
    }

    public boolean isAvailable(@Nullable Project project) {
        return project != null && JavaPsiFacade.getInstance((Project)project).findClass(this.getLoggerTypeName(), ProjectContainingLibrariesScope.Companion.getScope(project)) != null && LombokLibraryUtil.hasLombokLibrary(project);
    }

    public boolean isAvailable(@Nullable Module module) {
        return module != null && JavaLibraryUtil.hasLibraryClass((Module)module, (String)this.getLoggerTypeName()) && LombokLibraryUtil.hasLombokClasses(module);
    }

    public boolean isPossibleToPlaceLoggerAtClass(@NotNull PsiClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return !clazz.hasAnnotation(this.annotationTypeName);
    }

    @NotNull
    public PsiAnnotation createLogger(@NotNull Project project, @NotNull PsiClass clazz) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiAnnotation psiAnnotation = factory.createAnnotationFromText("@" + this.annotationTypeName, (PsiElement)clazz);
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"createAnnotationFromText(...)");
        return psiAnnotation;
    }

    @NotNull
    public String getLogFieldName(@NotNull PsiClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        String string = AbstractLogProcessor.getLoggerName(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLoggerName(...)");
        return string;
    }
}

