/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.core.service;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.service.KotlinVersionKind;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardKotlinVersion;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardService;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.DefaultRepository;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repositories;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repository;
import org.jetbrains.kotlin.tools.projectWizard.settings.version.Version;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0004\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardService;", "<init>", "()V", "getKotlinVersion", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardKotlinVersion;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "kotlinVersionWithDefaultValues", "version", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/version/Version;", "getKotlinVersionRepository", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Repository;", "versionKind", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionKind;", "getDevVersionRepository", "getKotlinVersionKind", "Companion", "intellij.kotlin.projectWizard.core"})
public abstract class KotlinVersionProviderService
implements WizardService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract WizardKotlinVersion getKotlinVersion(@NotNull ProjectKind var1);

    @NotNull
    protected final WizardKotlinVersion kotlinVersionWithDefaultValues(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new WizardKotlinVersion(version, this.getKotlinVersionKind(version), this.getKotlinVersionRepository(version), Companion.getBuildSystemPluginRepository(this.getKotlinVersionKind(version), CollectionsKt.listOf((Object)this.getDevVersionRepository())));
    }

    private final Repository getKotlinVersionRepository(KotlinVersionKind versionKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[versionKind.ordinal()]) {
            case 1, 2, 3 -> DefaultRepository.Companion.getMAVEN_CENTRAL();
            case 4 -> this.getDevVersionRepository();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    protected Repository getDevVersionRepository() {
        return Repositories.INSTANCE.getJETBRAINS_KOTLIN_DEV();
    }

    @NotNull
    protected final Repository getKotlinVersionRepository(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.getKotlinVersionRepository(this.getKotlinVersionKind(version));
    }

    @NotNull
    protected final KotlinVersionKind getKotlinVersionKind(@NotNull Version version) {
        KotlinVersionKind kotlinVersionKind;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = version.toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"eap", (boolean)false, (int)2, null)) {
            kotlinVersionKind = KotlinVersionKind.EAP;
        } else {
            string = version.toString();
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"rc", (boolean)false, (int)2, null)) {
                kotlinVersionKind = KotlinVersionKind.EAP;
            } else {
                string = version.toString();
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string4 = string.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"dev", (boolean)false, (int)2, null)) {
                    kotlinVersionKind = KotlinVersionKind.DEV;
                } else {
                    string = version.toString();
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string5 = string.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    kotlinVersionKind = StringsKt.contains$default((CharSequence)string5, (CharSequence)"m", (boolean)false, (int)2, null) ? KotlinVersionKind.M : KotlinVersionKind.STABLE;
                }
            }
        }
        return kotlinVersionKind;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionProviderService$Companion;", "", "<init>", "()V", "getBuildSystemPluginRepository", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/buildSystem/BuildSystemType;", "", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Repository;", "versionKind", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionKind;", "devRepositories", "intellij.kotlin.projectWizard.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<BuildSystemType, List<Repository>> getBuildSystemPluginRepository(@NotNull KotlinVersionKind versionKind, @NotNull List<? extends Repository> devRepositories) {
            Intrinsics.checkNotNullParameter((Object)((Object)versionKind), (String)"versionKind");
            Intrinsics.checkNotNullParameter(devRepositories, (String)"devRepositories");
            return switch (WhenMappings.$EnumSwitchMapping$1[versionKind.ordinal()]) {
                case 1, 2, 3 -> Companion::getBuildSystemPluginRepository$lambda$0;
                case 4 -> arg_0 -> Companion.getBuildSystemPluginRepository$lambda$1(devRepositories, arg_0);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private static final List getBuildSystemPluginRepository$lambda$0(BuildSystemType buildSystem) {
            Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
            return switch (WhenMappings.$EnumSwitchMapping$0[buildSystem.ordinal()]) {
                case 1, 2 -> {
                    Object[] var1_1 = new DefaultRepository[]{DefaultRepository.Companion.getMAVEN_CENTRAL(), DefaultRepository.Companion.getGRADLE_PLUGIN_PORTAL()};
                    yield CollectionsKt.listOf((Object[])var1_1);
                }
                case 3 -> CollectionsKt.listOf((Object)DefaultRepository.Companion.getMAVEN_CENTRAL());
                case 4 -> CollectionsKt.emptyList();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private static final List getBuildSystemPluginRepository$lambda$1(List $devRepositories, BuildSystemType buildSystemType) {
            Intrinsics.checkNotNullParameter((Object)buildSystemType, (String)"<unused var>");
            return $devRepositories;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[BuildSystemType.values().length];
                try {
                    nArray[BuildSystemType.GradleKotlinDsl.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuildSystemType.GradleGroovyDsl.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuildSystemType.Maven.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuildSystemType.Jps.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[KotlinVersionKind.values().length];
                try {
                    nArray[KotlinVersionKind.STABLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KotlinVersionKind.EAP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KotlinVersionKind.M.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KotlinVersionKind.DEV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinVersionKind.values().length];
            try {
                nArray[KotlinVersionKind.STABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinVersionKind.EAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinVersionKind.M.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinVersionKind.DEV.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

