/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\tH\u0014J\b\u0010\u0011\u001a\u00020\tH\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "annotationInnerText", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Ljava/lang/String;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "renderArgumentsForIntentionName", "getFamilyName", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Kind", "kotlin.fir.frontend-independent"})
public class AddAnnotationFix
extends PsiUpdateModCommandAction<KtElement> {
    @NotNull
    private final ClassId annotationClassId;
    @NotNull
    private final Kind kind;
    @Nullable
    private final String annotationInnerText;

    public AddAnnotationFix(@NotNull KtElement element, @NotNull ClassId annotationClassId, @NotNull Kind kind2, @Nullable String annotationInnerText) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        super((PsiElement)element);
        this.annotationClassId = annotationClassId;
        this.kind = kind2;
        this.annotationInnerText = annotationInnerText;
    }

    public /* synthetic */ AddAnnotationFix(KtElement ktElement, ClassId classId, Kind kind2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kind2 = Kind.Self.INSTANCE;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(ktElement, classId, kind2, string);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String annotationCall = RenderingUtilsKt.render$default((Name)this.annotationClassId.getShortClassName(), (boolean)false, (int)1, null) + this.renderArgumentsForIntentionName();
        Kind kind2 = this.kind;
        if (Intrinsics.areEqual((Object)kind2, (Object)Kind.Self.INSTANCE)) {
            var6_5 = new Object[]{annotationCall};
            string = KotlinBundle.message((String)"fix.add.annotation.text.self", (Object[])var6_5);
        } else if (Intrinsics.areEqual((Object)kind2, (Object)Kind.Constructor.INSTANCE)) {
            var6_5 = new Object[]{annotationCall};
            string = KotlinBundle.message((String)"fix.add.annotation.text.constructor", (Object[])var6_5);
        } else if (kind2 instanceof Kind.Declaration) {
            var6_5 = new Object[2];
            var6_5[0] = annotationCall;
            String string2 = ((Kind.Declaration)this.kind).getName();
            if (string2 == null) {
                string2 = "?";
            }
            var6_5[1] = string2;
            string = KotlinBundle.message((String)"fix.add.annotation.text.declaration", (Object[])var6_5);
        } else if (kind2 instanceof Kind.ContainingClass) {
            var6_5 = new Object[2];
            var6_5[0] = annotationCall;
            String string3 = ((Kind.ContainingClass)this.kind).getName();
            if (string3 == null) {
                string3 = "?";
            }
            var6_5[1] = string3;
            string = KotlinBundle.message((String)"fix.add.annotation.text.containing.class", (Object[])var6_5);
        } else if (kind2 instanceof Kind.Copy) {
            var6_5 = new Object[]{annotationCall, ((Kind.Copy)this.kind).getSource(), ((Kind.Copy)this.kind).getTarget()};
            string = KotlinBundle.message((String)"fix.add.annotation.with.arguments.text.copy", (Object[])var6_5);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String actionName = string;
        return Presentation.of((String)actionName);
    }

    @NotNull
    protected String renderArgumentsForIntentionName() {
        String string = this.annotationInnerText;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.annotation.family", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtElement element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        AnnotationModificationUtilsKt.addAnnotation(element, this.annotationClassId, this.annotationInnerText, false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "", "<init>", "()V", "Self", "Constructor", "Declaration", "ContainingClass", "Copy", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Constructor;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$ContainingClass;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Copy;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Declaration;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Self;", "kotlin.fir.frontend-independent"})
    public static abstract sealed class Kind {
        private Kind() {
        }

        public /* synthetic */ Kind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Constructor;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin.fir.frontend-independent"})
        public static final class Constructor
        extends Kind {
            @NotNull
            public static final Constructor INSTANCE = new Constructor();

            private Constructor() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Constructor";
            }

            public int hashCode() {
                return -767814225;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Constructor)) {
                    return false;
                }
                Constructor cfr_ignored_0 = (Constructor)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$ContainingClass;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.fir.frontend-independent"})
        public static final class ContainingClass
        extends Kind {
            @Nullable
            private final String name;

            public ContainingClass(@Nullable String name2) {
                super(null);
                this.name = name2;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final ContainingClass copy(@Nullable String name2) {
                return new ContainingClass(name2);
            }

            public static /* synthetic */ ContainingClass copy$default(ContainingClass containingClass, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = containingClass.name;
                }
                return containingClass.copy(string);
            }

            @NotNull
            public String toString() {
                return "ContainingClass(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name == null ? 0 : this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ContainingClass)) {
                    return false;
                }
                ContainingClass containingClass = (ContainingClass)other;
                return Intrinsics.areEqual((Object)this.name, (Object)containingClass.name);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Copy;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "source", "", "target", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.fir.frontend-independent"})
        public static final class Copy
        extends Kind {
            @NotNull
            private final String source;
            @NotNull
            private final String target;

            public Copy(@NotNull String source, @NotNull String target) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(null);
                this.source = source;
                this.target = target;
            }

            @NotNull
            public final String getSource() {
                return this.source;
            }

            @NotNull
            public final String getTarget() {
                return this.target;
            }

            @NotNull
            public final String component1() {
                return this.source;
            }

            @NotNull
            public final String component2() {
                return this.target;
            }

            @NotNull
            public final Copy copy(@NotNull String source, @NotNull String target) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return new Copy(source, target);
            }

            public static /* synthetic */ Copy copy$default(Copy copy, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = copy.source;
                }
                if ((n & 2) != 0) {
                    string2 = copy.target;
                }
                return copy.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Copy(source=" + this.source + ", target=" + this.target + ")";
            }

            public int hashCode() {
                int result2 = this.source.hashCode();
                result2 = result2 * 31 + this.target.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Copy)) {
                    return false;
                }
                Copy copy = (Copy)other;
                if (!Intrinsics.areEqual((Object)this.source, (Object)copy.source)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.target, (Object)copy.target);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Declaration;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.fir.frontend-independent"})
        public static final class Declaration
        extends Kind {
            @Nullable
            private final String name;

            public Declaration(@Nullable String name2) {
                super(null);
                this.name = name2;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Declaration copy(@Nullable String name2) {
                return new Declaration(name2);
            }

            public static /* synthetic */ Declaration copy$default(Declaration declaration, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = declaration.name;
                }
                return declaration.copy(string);
            }

            @NotNull
            public String toString() {
                return "Declaration(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name == null ? 0 : this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Declaration)) {
                    return false;
                }
                Declaration declaration = (Declaration)other;
                return Intrinsics.areEqual((Object)this.name, (Object)declaration.name);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Self;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin.fir.frontend-independent"})
        public static final class Self
        extends Kind {
            @NotNull
            public static final Self INSTANCE = new Self();

            private Self() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Self";
            }

            public int hashCode() {
                return -1528470729;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Self)) {
                    return false;
                }
                Self cfr_ignored_0 = (Self)other;
                return true;
            }
        }
    }
}

