/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration.klib;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KotlinNativeLibrariesFixer;", "", "<init>", "()V", "applyTo", "", "ownerNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "fixLibraryName", "libraryData", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "fixLibraryDependencyLevel", "oldDependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/LibraryDependencyData;", "intellij.kotlin.gradle.gradle"})
public final class KotlinNativeLibrariesFixer {
    @NotNull
    public static final KotlinNativeLibrariesFixer INSTANCE = new KotlinNativeLibrariesFixer();

    private KotlinNativeLibrariesFixer() {
    }

    public final void applyTo(@NotNull DataNode<? extends GradleSourceSetData> ownerNode, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkNotNullParameter(ownerNode, (String)"ownerNode");
        Intrinsics.checkNotNullParameter(ideProject, (String)"ideProject");
        for (DataNode libraryDependencyNode : ExternalSystemApiUtil.findAll(ownerNode, (Key)ProjectKeys.LIBRARY_DEPENDENCY)) {
            AbstractExternalEntityData abstractExternalEntityData = ((LibraryDependencyData)libraryDependencyNode.getData()).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalEntityData, (String)"getTarget(...)");
            LibraryData libraryData = (LibraryData)abstractExternalEntityData;
            String string = libraryData.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"Gradle: Kotlin/Native", (boolean)false, (int)2, null)) continue;
            this.fixLibraryName(libraryData);
            GradleProjectResolverUtil.linkProjectLibrary(ideProject, (LibraryData)libraryData);
            Intrinsics.checkNotNull((Object)libraryDependencyNode);
            this.fixLibraryDependencyLevel((DataNode<LibraryDependencyData>)libraryDependencyNode);
        }
    }

    private final void fixLibraryName(LibraryData libraryData) {
        String string = libraryData.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        libraryData.setInternalName(StringsKt.substringAfter$default((String)string, (String)"Gradle: ", null, (int)2, null));
    }

    private final void fixLibraryDependencyLevel(DataNode<LibraryDependencyData> oldDependencyNode) {
        LibraryDependencyData libraryDependencyData;
        Object object = oldDependencyNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        LibraryDependencyData oldDependency = (LibraryDependencyData)object;
        if (oldDependency.getLevel() == LibraryLevel.PROJECT) {
            return;
        }
        LibraryDependencyData $this$fixLibraryDependencyLevel_u24lambda_u240 = libraryDependencyData = new LibraryDependencyData(oldDependency.getOwnerModule(), (LibraryData)oldDependency.getTarget(), LibraryLevel.PROJECT);
        boolean bl = false;
        $this$fixLibraryDependencyLevel_u24lambda_u240.setScope(oldDependency.getScope());
        $this$fixLibraryDependencyLevel_u24lambda_u240.setOrder(oldDependency.getOrder());
        $this$fixLibraryDependencyLevel_u24lambda_u240.setExported(oldDependency.isExported());
        LibraryDependencyData newDependency = libraryDependencyData;
        DataNode dataNode = oldDependencyNode.getParent();
        if (dataNode == null) {
            return;
        }
        DataNode parentNode = dataNode;
        Collection collection = oldDependencyNode.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
        Collection childNodes = collection;
        DataNode dataNode2 = parentNode.createChild(oldDependencyNode.getKey(), (Object)newDependency);
        Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"createChild(...)");
        DataNode newDependencyNode = dataNode2;
        for (DataNode child : childNodes) {
            newDependencyNode.addChild(child);
        }
        oldDependencyNode.clear(true);
    }
}

