/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaBackingFieldSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.CallableReturnTypeUpdaterUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0014\u0010!\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J \u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'*\u00020\u00122\u0006\u0010\n\u001a\u00020*H\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IntroduceBackingPropertyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IntroduceBackingPropertyIntention$Context;", "<init>", "()V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "element", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isApplicableByPsi", "", "isBackingFieldRequiredAndCanBeUsed", "property", "introduceBackingProperty", "context", "replaceFieldReferences", "project", "Lcom/intellij/openapi/project/Project;", "propertyName", "removeInitializer", "addAccessors", "createGetter", "createSetter", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "createBackingProperty", "backingName", "collectFieldReferences", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Context", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nIntroduceBackingPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IntroduceBackingPropertyIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,195:1\n249#2:196\n2746#3,3:197\n1#4:200\n25#5:201\n29#5,7:202\n*S KotlinDebug\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IntroduceBackingPropertyIntention\n*L\n54#1:196\n56#1:197,3\n92#1:201\n96#1:202,7\n*E\n"})
public final class IntroduceBackingPropertyIntention
extends KotlinApplicableModCommandAction<KtProperty, Context> {
    public IntroduceBackingPropertyIntention() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        this.introduceBackingProperty(element, elementContext, updater2);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"introduce.backing.property", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        Context context2;
        block20: {
            block14: {
                KtPropertyAccessor ktPropertyAccessor;
                Object getterFieldReferences;
                block19: {
                    block17: {
                        block18: {
                            block16: {
                                Object object;
                                block15: {
                                    KtPropertyAccessor it;
                                    boolean bl;
                                    block13: {
                                        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
                                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                        String string = element.getName();
                                        if (string == null) {
                                            return null;
                                        }
                                        String name2 = string;
                                        if (!this.isBackingFieldRequiredAndCanBeUsed($this$prepareContext, element)) {
                                            return null;
                                        }
                                        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
                                        boolean $i$f$getStrictParentOfType = false;
                                        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
                                        if (ktClassOrObject == null) {
                                            return null;
                                        }
                                        KtClassOrObject containingClass = ktClassOrObject;
                                        if (KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)containingClass))) {
                                            return null;
                                        }
                                        Iterable $this$none$iv = containingClass.getDeclarations();
                                        boolean $i$f$none = false;
                                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                            bl = true;
                                        } else {
                                            for (Object element$iv : $this$none$iv) {
                                                it = (KtDeclaration)element$iv;
                                                boolean bl2 = false;
                                                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)("_" + name2)))) continue;
                                                bl = false;
                                                break block13;
                                            }
                                            bl = true;
                                        }
                                    }
                                    if (!bl) break block14;
                                    object = element.getGetter();
                                    if (object == null) break block15;
                                    it = object;
                                    boolean bl3 = false;
                                    List<SmartPsiElementPointer<KtSimpleNameExpression>> list2 = this.collectFieldReferences($this$prepareContext, (KtElement)it);
                                    object = list2;
                                    if (list2 != null) break block16;
                                }
                                object = getterFieldReferences = CollectionsKt.emptyList();
                            }
                            if (!element.isVar()) break block17;
                            ktPropertyAccessor = element.getSetter();
                            if (ktPropertyAccessor == null) break block18;
                            KtPropertyAccessor it = ktPropertyAccessor;
                            boolean bl = false;
                            KtPropertyAccessor ktPropertyAccessor2 = this.collectFieldReferences($this$prepareContext, (KtElement)it);
                            ktPropertyAccessor = ktPropertyAccessor2;
                            if (ktPropertyAccessor2 != null) break block19;
                        }
                        ktPropertyAccessor = CollectionsKt.emptyList();
                        break block19;
                    }
                    ktPropertyAccessor = CollectionsKt.emptyList();
                }
                KtPropertyAccessor setterFieldReferences = ktPropertyAccessor;
                context2 = new Context(CallableReturnTypeUpdaterUtils.getTypeInfo$default(CallableReturnTypeUpdaterUtils.INSTANCE, $this$prepareContext, (KtCallableDeclaration)element, false, false, 12, null), (List<? extends SmartPsiElementPointer<KtSimpleNameExpression>>)getterFieldReferences, (List<? extends SmartPsiElementPointer<KtSimpleNameExpression>>)setterFieldReferences);
                break block20;
            }
            context2 = null;
        }
        return context2;
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getName() == null) {
            return false;
        }
        if (element.hasModifier(KtTokens.CONST_KEYWORD)) {
            return false;
        }
        return !AnnotationModificationUtilsKt.hasJvmFieldAnnotation((KtAnnotated)element);
    }

    private final boolean isBackingFieldRequiredAndCanBeUsed(KaSession $this$isBackingFieldRequiredAndCanBeUsed, KtProperty property) {
        KtPropertyAccessor ktPropertyAccessor;
        if (KotlinCommonRefactoringUtilKt.isAbstract((KtDeclaration)property)) {
            return false;
        }
        if (property.isLocal()) {
            return false;
        }
        if (AnalysisUtilsKt.isBackingFieldRequired($this$isBackingFieldRequiredAndCanBeUsed, property)) {
            return true;
        }
        KtPropertyAccessor getter = property.getGetter();
        return property.isVar() || ((ktPropertyAccessor = getter) != null && (ktPropertyAccessor = ktPropertyAccessor.getBodyExpression()) != null ? $this$isBackingFieldRequiredAndCanBeUsed.evaluate((KtExpression)ktPropertyAccessor) : null) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final void introduceBackingProperty(KtProperty element, Context context2, ModPsiUpdater updater2) {
        PsiElement psiElement;
        void $this$replaced$iv;
        this.createBackingProperty(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = element.getName();
        Intrinsics.checkNotNull((Object)string);
        this.replaceFieldReferences(project2, string, context2, updater2);
        PsiElement $this$copied$iv = (PsiElement)element;
        boolean $i$f$copied22 = false;
        PsiElement psiElement2 = $this$copied$iv.copy();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        KtProperty copiedProperty = (KtProperty)((PsiElement)((KtProperty)psiElement2));
        this.addAccessors(copiedProperty);
        this.removeInitializer(project2, copiedProperty, context2);
        PsiElement $i$f$copied22 = (PsiElement)element;
        PsiElement newElement$iv = (PsiElement)copiedProperty;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtProperty) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                psiElement = (PsiElement)((KtProperty)ktExpression);
            }
        }
        KtProperty replaced = (KtProperty)psiElement;
        KtTypeReference ktTypeReference = replaced.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference it = ktTypeReference;
            boolean bl = false;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)it);
        }
        GenericPsiUtils.reformat$default((PsiElement)replaced, false, 1, null);
    }

    private final void replaceFieldReferences(Project project, String propertyName, Context context2, ModPsiUpdater updater2) {
        for (SmartPsiElementPointer<KtSimpleNameExpression> getterFieldReference : context2.getGetterFieldReferences()) {
            IntroduceBackingPropertyIntention.replaceFieldReferences$replaceFieldReference(project, propertyName, updater2, getterFieldReference);
        }
        for (SmartPsiElementPointer<KtSimpleNameExpression> setterFieldReference : context2.getSetterFieldReferences()) {
            IntroduceBackingPropertyIntention.replaceFieldReferences$replaceFieldReference(project, propertyName, updater2, setterFieldReference);
        }
    }

    private final void removeInitializer(Project project, KtProperty property, Context context2) {
        property.removeModifier(KtTokens.LATEINIT_KEYWORD);
        if (property.getTypeReference() == null) {
            CallableReturnTypeUpdaterUtils.INSTANCE.updateTypeForDeclarationInDummyFile((KtCallableDeclaration)property, context2.getTypeInfo(), project);
        }
        property.setInitializer(null);
    }

    private final void addAccessors(KtProperty property) {
        KtPropertyAccessor setter;
        KtPropertyAccessor getter = property.getGetter();
        if (getter == null) {
            this.createGetter(property);
        }
        if (property.isVar() && (setter = property.getSetter()) == null) {
            this.createSetter(property);
        }
    }

    private final void createGetter(KtProperty element) {
        String body2 = "get() = " + this.backingName(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project, false, 2, null).createProperty("val x " + body2).getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newGetter = ktPropertyAccessor;
        this.addAccessor(element, newGetter);
    }

    private final void createSetter(KtProperty element) {
        String body2 = "set(value) { " + this.backingName(element) + " = value }";
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project, false, 2, null).createProperty("val x " + body2).getSetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newSetter = ktPropertyAccessor;
        this.addAccessor(element, newSetter);
    }

    private final void addAccessor(KtProperty $this$addAccessor, KtPropertyAccessor newAccessor) {
        ASTNode semicolon = $this$addAccessor.getNode().findChildByType((IElementType)KtTokens.SEMICOLON);
        ASTNode aSTNode = semicolon;
        $this$addAccessor.addBefore((PsiElement)newAccessor, (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
    }

    private final void createBackingProperty(KtProperty property) {
        Project project = property.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtDeclaration backingProperty = CreateByPatternKt.buildDeclaration((KtPsiFactory)new KtPsiFactory(project, false, 2, null), arg_0 -> IntroduceBackingPropertyIntention.createBackingProperty$lambda$0(property, this, arg_0));
        if (property.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            backingProperty.addModifier(KtTokens.LATEINIT_KEYWORD);
        }
        property.getParent().addBefore((PsiElement)backingProperty, (PsiElement)property);
    }

    private final String backingName(KtProperty property) {
        Object object = property.getNameIdentifier();
        return (object != null && (object = object.getText()) != null ? StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)'`', (boolean)false, (int)2, null) : false) ? "`_" + property.getName() + "`" : "_" + property.getName();
    }

    private final List<SmartPsiElementPointer<KtSimpleNameExpression>> collectFieldReferences(KaSession $this$collectFieldReferences, KtElement element) {
        List fieldReferences = new ArrayList();
        element.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid($this$collectFieldReferences, fieldReferences){
            final /* synthetic */ KaSession $this_collectFieldReferences;
            final /* synthetic */ List<SmartPsiElementPointer<KtSimpleNameExpression>> $fieldReferences;
            {
                this.$this_collectFieldReferences = $receiver;
                this.$fieldReferences = $fieldReferences;
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                KaSymbol variableSymbol = this.$this_collectFieldReferences.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)expression));
                if (variableSymbol instanceof KaBackingFieldSymbol) {
                    this.$fieldReferences.add((SmartPsiElementPointer<KtSimpleNameExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)expression)));
                }
            }
        });
        return fieldReferences;
    }

    private static final void replaceFieldReferences$replaceFieldReference(Project $project, String $propertyName, ModPsiUpdater $updater, SmartPsiElementPointer<KtSimpleNameExpression> reference) {
        KtSimpleNameExpression ktSimpleNameExpression;
        block3: {
            block2: {
                ktSimpleNameExpression = (KtSimpleNameExpression)reference.getElement();
                if (ktSimpleNameExpression == null) break block2;
                KtSimpleNameExpression it = ktSimpleNameExpression;
                boolean bl = false;
                KtSimpleNameExpression ktSimpleNameExpression2 = (KtSimpleNameExpression)$updater.getWritable((PsiElement)it);
                ktSimpleNameExpression = ktSimpleNameExpression2;
                if (ktSimpleNameExpression2 != null) break block3;
            }
            return;
        }
        KtSimpleNameExpression writableElement = ktSimpleNameExpression;
        writableElement.replace((PsiElement)new KtPsiFactory($project, false, 2, null).createSimpleName("_" + $propertyName));
    }

    private static final Unit createBackingProperty$lambda$0(KtProperty $property, IntroduceBackingPropertyIntention this$0, BuilderByPattern $this$buildDeclaration) {
        Intrinsics.checkNotNullParameter((Object)$this$buildDeclaration, (String)"$this$buildDeclaration");
        $this$buildDeclaration.appendFixedText("private ");
        String string = $property.getValOrVarKeyword().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$buildDeclaration.appendFixedText(string);
        $this$buildDeclaration.appendFixedText(" ");
        $this$buildDeclaration.appendNonFormattedText(this$0.backingName($property));
        if ($property.getTypeReference() != null) {
            $this$buildDeclaration.appendFixedText(": ");
            $this$buildDeclaration.appendTypeReference($property.getTypeReference());
        }
        if ($property.getInitializer() != null) {
            $this$buildDeclaration.appendFixedText(" = ");
            $this$buildDeclaration.appendExpression($property.getInitializer());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IntroduceBackingPropertyIntention$Context;", "", "typeInfo", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/CallableReturnTypeUpdaterUtils$TypeInfo;", "getterFieldReferences", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "setterFieldReferences", "<init>", "(Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/CallableReturnTypeUpdaterUtils$TypeInfo;Ljava/util/List;Ljava/util/List;)V", "getTypeInfo", "()Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/CallableReturnTypeUpdaterUtils$TypeInfo;", "getGetterFieldReferences", "()Ljava/util/List;", "getSetterFieldReferences", "kotlin.code-insight.intentions.shared"})
    public static final class Context {
        @NotNull
        private final CallableReturnTypeUpdaterUtils.TypeInfo typeInfo;
        @NotNull
        private final List<SmartPsiElementPointer<KtSimpleNameExpression>> getterFieldReferences;
        @NotNull
        private final List<SmartPsiElementPointer<KtSimpleNameExpression>> setterFieldReferences;

        public Context(@NotNull CallableReturnTypeUpdaterUtils.TypeInfo typeInfo, @NotNull List<? extends SmartPsiElementPointer<KtSimpleNameExpression>> getterFieldReferences, @NotNull List<? extends SmartPsiElementPointer<KtSimpleNameExpression>> setterFieldReferences) {
            Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
            Intrinsics.checkNotNullParameter(getterFieldReferences, (String)"getterFieldReferences");
            Intrinsics.checkNotNullParameter(setterFieldReferences, (String)"setterFieldReferences");
            this.typeInfo = typeInfo;
            this.getterFieldReferences = getterFieldReferences;
            this.setterFieldReferences = setterFieldReferences;
        }

        @NotNull
        public final CallableReturnTypeUpdaterUtils.TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        @NotNull
        public final List<SmartPsiElementPointer<KtSimpleNameExpression>> getGetterFieldReferences() {
            return this.getterFieldReferences;
        }

        @NotNull
        public final List<SmartPsiElementPointer<KtSimpleNameExpression>> getSetterFieldReferences() {
            return this.setterFieldReferences;
        }
    }
}

