/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.kotlin.commonNative.debugger.DebugExecutionAware;
import com.jetbrains.kotlin.commonNative.debugger.workspace.WorkspaceBase;
import com.jetbrains.mpp.MPPWorkspace;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/mpp/debugger/MPPDebugExecutionAware;", "Lcom/jetbrains/kotlin/commonNative/debugger/DebugExecutionAware;", "<init>", "()V", "getParams", "", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin-ultimate.ultimate-native"})
@SourceDebugExtension(value={"SMAP\nMPPDebugExecutionAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MPPDebugExecutionAware.kt\ncom/jetbrains/mpp/debugger/MPPDebugExecutionAware\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,39:1\n30#2,2:40\n*S KotlinDebug\n*F\n+ 1 MPPDebugExecutionAware.kt\ncom/jetbrains/mpp/debugger/MPPDebugExecutionAware\n*L\n20#1:40,2\n*E\n"})
public final class MPPDebugExecutionAware
extends DebugExecutionAware {
    @Override
    @NotNull
    public Map<String, String> getParams(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.LINUX_X64.INSTANCE};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(HostManager.Companion.getHost())) {
            return MapsKt.emptyMap();
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<WorkspaceBase> serviceClass$iv = WorkspaceBase.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.mpp.MPPWorkspace");
        MPPWorkspace workspace = (MPPWorkspace)object;
        File file = workspace.getLldbHome();
        if (file == null) {
            return MapsKt.emptyMap();
        }
        File lldbHome = file;
        HashMap params = new HashMap();
        ((Map)params).put("PROJECT_PATH", String.valueOf(project.getBasePath()));
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_ARM64.INSTANCE)) {
            ((Map)params).put("DEBUG_SERVER_PATH", FilesKt.resolve((File)lldbHome, (String)"LLDB.framework/Resources/debugserver").toString());
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            ((Map)params).put("DEBUG_SERVER_PATH", FilesKt.resolve((File)lldbHome, (String)"bin/lldb-server").toString());
            ((Map)params).put("DEBUG_SERVER_ARGS", "g");
        }
        return params;
    }
}

