/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "isImplicitContextVariable", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "variable", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;)Ljava/lang/Boolean;", "tryResolveToDeclaration", "Lcom/intellij/psi/PsiElement;", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "variableName", "", "dropInlinerSuffix", "receivedName", "resolveToDeclaration", "value", "Companion", "kotlin-ultimate.native-debugger"})
@SourceDebugExtension(value={"SMAP\nKonanDebuggerTypesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonanDebuggerTypesHelper.kt\ncom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,72:1\n1069#2,2:73\n*S KotlinDebug\n*F\n+ 1 KonanDebuggerTypesHelper.kt\ncom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper\n*L\n40#1:73,2\n*E\n"})
public final class KonanDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KONAN_NAME_FOR_THIS = "_this";

    public KonanDebuggerTypesHelper(@NotNull CidrDebugProcess process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        super(process2);
    }

    @NotNull
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue variable) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual((Object)variable.getName(), (Object)KONAN_NAME_FOR_THIS);
    }

    private final PsiElement tryResolveToDeclaration(KtBlockExpression blockExpression, String variableName) {
        Project project = this.myProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        KtExpression codeFragment = new KtPsiFactory(project, false).createExpressionCodeFragment(variableName, (PsiElement)blockExpression).getContentElement();
        KtReferenceExpression referenceExpression = codeFragment instanceof KtReferenceExpression ? (KtReferenceExpression)codeFragment : null;
        KtReferenceExpression ktReferenceExpression = referenceExpression;
        return ktReferenceExpression != null && (ktReferenceExpression = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression)) != null ? ktReferenceExpression.resolve() : null;
    }

    private final String dropInlinerSuffix(String receivedName) {
        int index2 = StringsKt.lastIndexOf$default((CharSequence)receivedName, (char)'_', (int)0, (boolean)false, (int)6, null);
        if (index2 <= 0) {
            return receivedName;
        }
        String string = receivedName.substring(index2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String suffix2 = string;
        if (((CharSequence)suffix2).length() > 0) {
            boolean bl;
            block4: {
                CharSequence $this$all$iv = suffix2;
                boolean $i$f$all = false;
                for (int j = 0; j < $this$all$iv.length(); ++j) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(j);
                    boolean bl2 = false;
                    if (Character.isDigit(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (bl) {
                String string2 = receivedName.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return string2;
            }
        }
        return receivedName;
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue value) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (Intrinsics.areEqual((Object)value.getName(), (Object)KONAN_NAME_FOR_THIS)) break block6;
                Project project = this.myProcess.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                if (!DumbService.Companion.getInstance(project).isDumb()) break block7;
            }
            return null;
        }
        XSourcePosition xSourcePosition = position;
        if (xSourcePosition == null) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
        KtBlockExpression ktBlockExpression = Companion.findBlockAtPosition(xSourcePosition, cidrDebugProcess);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression blockExpression = ktBlockExpression;
        Object[] objectArray = new String[2];
        String string = value.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        objectArray[0] = this.dropInlinerSuffix(string);
        Intrinsics.checkNotNullExpressionValue((Object)value.getName(), (String)"getName(...)");
        for (String name2 : CollectionsKt.listOf((Object[])objectArray)) {
            PsiElement declaration;
            if (this.tryResolveToDeclaration(blockExpression, name2) == null || declaration.getTextRange().getStartOffset() > position.getOffset()) continue;
            return declaration;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper$Companion;", "", "<init>", "()V", "KONAN_NAME_FOR_THIS", "", "findBlockAtPosition", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "kotlin-ultimate.native-debugger"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtBlockExpression findBlockAtPosition(@NotNull XSourcePosition position, @NotNull CidrDebugProcess process2) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Class[] classArray = new Class[]{KtBlockExpression.class};
            return (KtBlockExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)CidrDebuggerTypesHelper.getContextElement((XSourcePosition)position, (Project)process2.getProject()), (Class[])classArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

