/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class AddDataSourceFromUrl
extends DumbAwareAction {
    private final DatabaseViewActions.DataSourceFactory myFactory;

    public AddDataSourceFromUrl(@NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (factory == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message((String)"data.source.from.url.text", (Object[])new Object[0]), null, DatabaseIcons.Connector);
        this.myFactory = factory;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && DatabaseViewActions.isDataSourceActionsEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        AddDataSourceFromUrl.newDataSourceFromInput(project, this.myFactory, DatabaseViewActions.getFolderPath(e));
    }

    public static void newDataSourceFromInput(@NotNull Project project, @NotNull DatabaseViewActions.DataSourceFactory factory, @Nullable String groupName) {
        if (project == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(5);
        }
        DatabaseViewActions.DataSourceFactory adjustedFactory = (facade, manager, dataSource) -> {
            dataSource.setGroupName(groupName);
            factory.create(facade, (DataSourceManager<LocalDataSource>)manager, dataSource);
        };
        new MyDialog(project, adjustedFactory){
            {
                this.setTitle(DatabaseBundle.message((String)"data.source.from.url.title", (Object[])new Object[0]));
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)DatabaseBundle.message((String)"data.source.from.url.url", (Object[])new Object[0])));
            }

            @Override
            protected boolean useClipboardText(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(0);
                }
                return str.startsWith("jdbc:");
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArrayList<DatabaseDriver> filtered = new ArrayList<DatabaseDriver>();
                for (DatabaseDriver driver : this.myDrivers) {
                    if (!driver.matchesUrl(str)) continue;
                    filtered.add(driver);
                }
                if (filtered.isEmpty()) {
                    return (DatabaseDriver)ContainerUtil.getFirstItem(filtered);
                }
                return 1.disambiguate(str, (JBIterable<DatabaseDriver>)JBIterable.from(filtered));
            }

            @Nullable
            private static DatabaseDriver disambiguate(@NotNull String url, JBIterable<DatabaseDriver> filtered) {
                if (url == null) {
                    1.$$$reportNull$$$0(2);
                }
                return DbImplUtilCore.disambiguate((String)url, filtered);
            }

            @Override
            @NotNull
            protected Collection<? extends DatabaseDriver> getDatabaseDrivers() {
                Collection collection = DatabaseDriverManager.getInstance().getDrivers();
                if (collection == null) {
                    1.$$$reportNull$$$0(3);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "url";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDatabaseDrivers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "useClipboardText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "selectDriver";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "disambiguate";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newDataSourceFromInput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static abstract class MyDialog
    extends CreateFileFromTemplateDialog {
        private final DatabaseViewActions.DataSourceFactory myFactory;
        protected final List<DatabaseDriver> myDrivers;
        protected final DbPsiFacade myFacade;
        protected final DataSourceManager<LocalDataSource> myDataSourceManager;
        private boolean myKindUserEdited;
        private boolean myUpdating;

        MyDialog(@NotNull Project project, @NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (project == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myDrivers = new ArrayList<DatabaseDriver>();
            this.myFactory = factory;
            this.myFacade = DbPsiFacade.getInstance((Project)project);
            this.myDataSourceManager = LocalDataSourceManager.getInstance(project);
            this.setup();
        }

        private void setup() {
            this.getKindLabel().setText(UIUtil.replaceMnemonicAmpersand((String)DatabaseBundle.message((String)"new.data.source.driver", (Object[])new Object[0])));
            this.myDrivers.addAll(this.getDatabaseDrivers());
            this.myDrivers.sort(Comparator.comparing(DatabaseDriver::getName, NaturalComparator.INSTANCE));
            for (DatabaseDriver driver : this.myDrivers) {
                this.getKindCombo().addItem(driver.getName(), driver.getIcon(0), driver.getName());
            }
            this.setTemplateKindComponentsVisible(true);
            this.getNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myUpdating = true;
                    try {
                        DatabaseDriver driver = this.selectDriver(this.getNameField().getText());
                        if (driver != null) {
                            this.getKindCombo().setSelectedName(driver.getName());
                        } else if (!myKindUserEdited) {
                            this.getKindCombo().getComboBox().setSelectedItem(null);
                        }
                    }
                    finally {
                        myUpdating = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog$1", "textChanged"));
                }
            });
            String clipboardText = StringUtil.trim((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
            if (clipboardText != null && this.useClipboardText(clipboardText)) {
                this.getNameField().setText(clipboardText);
            }
            this.getKindCombo().getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!myUpdating) {
                        myKindUserEdited = true;
                    }
                }
            });
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (this.getKindCombo().getComboBox().getSelectedItem() == null) {
                return new ValidationInfo(DatabaseBundle.message((String)"data.source.from.url.no.driver", (Object[])new Object[0]));
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            String selectedName = this.getKindCombo().getSelectedName();
            DatabaseDriver driver = Objects.requireNonNull((DatabaseDriver)ContainerUtil.find(this.myDrivers, o -> Objects.equals(selectedName, o.getName())));
            String url = this.buildUrlForDriver(driver);
            ApplicationManager.getApplication().invokeLater(() -> {
                LocalDataSource dataSource = driver.createDataSource(null);
                dataSource.setUrlSmart(url);
                ((DatabaseDriverImpl)driver).setDefaultProperties(dataSource, true);
                this.myFactory.create(this.myFacade, this.myDataSourceManager, dataSource);
            });
            super.doOKAction();
        }

        @NotNull
        protected String buildUrlForDriver(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            String string = this.getNameField().getText();
            if (string == null) {
                MyDialog.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected abstract boolean useClipboardText(@NotNull String var1);

        @Nullable
        protected abstract DatabaseDriver selectDriver(@NotNull String var1);

        @NotNull
        protected abstract @Unmodifiable Collection<? extends DatabaseDriver> getDatabaseDrivers();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildUrlForDriver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUrlForDriver";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

