/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.custom;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomComponentDiscovererBeansModel
extends CacheableCommonSpringModel {
    private final Module myModule;
    @NotNull
    private final String myProviderName;

    public CustomComponentDiscovererBeansModel(@Nullable Module module, @NotNull String providerName) {
        if (providerName == null) {
            CustomComponentDiscovererBeansModel.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myProviderName = providerName;
    }

    @Override
    public Set<CommonSpringModel> getRelatedModels() {
        if (this.myModule == null) {
            return super.getRelatedModels();
        }
        return this.getLocalBeans().stream().map(pointer -> pointer.getSpringBean()).map(bean -> CustomComponentDiscovererBeansModel.mapSpringConfiguration(bean)).filter(Objects::nonNull).map(JamPsiClassSpringBean::getPsiElement).map(psiClass -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel((PsiClass)psiClass, this.myModule, this.getActiveProfiles())).collect(Collectors.toSet());
    }

    @Nullable
    private static SpringConfiguration mapSpringConfiguration(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            CustomComponentDiscovererBeansModel.$$$reportNull$$$0(1);
        }
        if (bean instanceof SpringConfiguration) {
            return (SpringConfiguration)bean;
        }
        if (bean instanceof SpringImplicitBean) {
            PsiClass psiClass = ((SpringImplicitBean)bean).getPsiElement();
            return (SpringConfiguration)JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass);
        }
        return null;
    }

    public String toString() {
        return this.myProviderName + ": " + String.valueOf(this.myModule);
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/custom/CustomComponentDiscovererBeansModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mapSpringConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

