/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;

public class LimitTokenOffsetFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "limitTokenOffset";
    public static final String MAX_START_OFFSET = "maxStartOffset";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    private int maxStartOffset;
    private boolean consumeAllTokens;

    public LimitTokenOffsetFilterFactory(Map<String, String> args) {
        super(args);
        this.maxStartOffset = this.requireInt(args, MAX_START_OFFSET);
        this.consumeAllTokens = this.getBoolean(args, CONSUME_ALL_TOKENS_KEY, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public LimitTokenOffsetFilterFactory() {
        throw LimitTokenOffsetFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenOffsetFilter(input, this.maxStartOffset, this.consumeAllTokens);
    }
}

