/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.model.Transformation;
import com.intellij.profiler.model.TransformationResult;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeTransformer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a_\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0002\u0010\u0005\"\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u00042\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u00072\u0006\u0010\b\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\t\u001am\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u000b\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0002\u0010\u0005\"\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u00042\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u00072\u0006\u0010\b\u001a\u0002H\u0003H\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"transformTree", "To", "FromData", "From", "Lcom/intellij/profiler/model/TreeNode;", "ToData", "transformer", "Lcom/intellij/profiler/model/TreeTransformer;", "node", "(Lcom/intellij/profiler/model/TreeTransformer;Lcom/intellij/profiler/model/TreeNode;)Lcom/intellij/profiler/model/TreeNode;", "applyTransformer", "Lcom/intellij/profiler/model/TransformationResult;", "(Lcom/intellij/profiler/model/TreeTransformer;Lcom/intellij/profiler/model/TreeNode;)Lcom/intellij/profiler/model/TransformationResult;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nTreeTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeTransformer.kt\ncom/intellij/profiler/model/TreeTransformerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1869#3,2:76\n*S KotlinDebug\n*F\n+ 1 TreeTransformer.kt\ncom/intellij/profiler/model/TreeTransformerKt\n*L\n41#1:76,2\n*E\n"})
public final class TreeTransformerKt {
    @NotNull
    public static final <FromData, From extends TreeNode<? extends FromData>, ToData, To extends TreeNode<? extends ToData>> To transformTree(@NotNull TreeTransformer<FromData, From, ToData, To> transformer2, @NotNull From node) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (!transformer2.preConditionChecker(node)) {
            boolean $i$a$-require-TreeTransformerKt$transformTree$22 = false;
            String $i$a$-require-TreeTransformerKt$transformTree$22 = "precondition check failed for " + transformer2;
            throw new IllegalArgumentException($i$a$-require-TreeTransformerKt$transformTree$22.toString());
        }
        TransformationResult<ToData, To> transformationResult = TreeTransformerKt.applyTransformer(transformer2, node);
        To returnValue = transformationResult.component1();
        To newHead = transformationResult.component2();
        Object[] objectArray = new TreeNode[]{node};
        List oldStack = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new TreeNode[]{newHead};
        List newStack = CollectionsKt.mutableListOf((Object[])objectArray2);
        while (!((Collection)oldStack).isEmpty()) {
            Object e = oldStack.removeLast();
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
            TreeNode oldTop = (TreeNode)e;
            Object e2 = newStack.removeLast();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"removeLast(...)");
            TreeNode newTop = (TreeNode)e2;
            transformer2.beforeChildrenProcessed(oldTop, newTop);
            Iterable $this$forEach$iv = transformer2.children(oldTop);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeNode oldChild = (TreeNode)element$iv;
                boolean bl = false;
                TransformationResult<ToData, To> transformationResult2 = TreeTransformerKt.applyTransformer(transformer2, oldChild);
                To newChild = transformationResult2.component1();
                To newListHead = transformationResult2.component2();
                transformer2.postProcess(newTop, (TreeNode)newChild);
                ((Collection)newStack).add(newListHead);
                ((Collection)oldStack).add(oldChild);
            }
            transformer2.afterChildrenProcessed(oldTop, newTop);
        }
        return returnValue;
    }

    private static final <FromData, From extends TreeNode<? extends FromData>, ToData, To extends TreeNode<? extends ToData>> TransformationResult<ToData, To> applyTransformer(TreeTransformer<FromData, From, ToData, To> transformer2, From node) {
        TransformationResult transformationResult;
        Transformation<To> transformation = transformer2.transform(node);
        if (transformation instanceof Transformation.Single) {
            transformationResult = new TransformationResult((TreeNode)((Transformation.Single)transformation).getData(), (TreeNode)((Transformation.Single)transformation).getData());
        } else if (transformation instanceof Transformation.ListOf) {
            TreeNode head;
            TreeNode currentNode = head = (TreeNode)CollectionsKt.first(((Transformation.ListOf)transformation).getList());
            List rest = CollectionsKt.drop((Iterable)((Transformation.ListOf)transformation).getList(), (int)1);
            while (!((Collection)rest).isEmpty()) {
                TreeNode child = (TreeNode)CollectionsKt.first((List)rest);
                transformer2.postProcess(currentNode, child);
                currentNode = child;
                rest = CollectionsKt.drop((Iterable)rest, (int)1);
            }
            transformationResult = new TransformationResult(head, currentNode);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return transformationResult;
    }
}

