/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public abstract class RawPlanData {
    public abstract void load(@NotNull DatabaseConnectionCore var1, @NotNull String var2, boolean var3);

    public abstract void load(@NotNull String var1);

    public abstract String dump();

    protected static StateSaver setAutoCommit(final boolean autoCommit) {
        return new StateSaver(){
            private Boolean myAutoCommit = null;

            @Override
            public void save(DatabaseConnectionCore conn) throws PlanRetrievalException {
                try {
                    this.myAutoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e) {
                    throw new PlanRetrievalException("Failed to set auto commit", (Throwable)e);
                }
            }

            @Override
            public void restore(DatabaseConnectionCore conn) {
                try {
                    if (this.myAutoCommit != null) {
                        conn.setAutoCommit(this.myAutoCommit.booleanValue());
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
    }

    protected static void useStatementWithPreserved(final DatabaseConnectionCore conn, final ResourceUser<? super ReusableSmartStatement<String>> user, StateSaver ... savers) throws PlanRetrievalException {
        RawPlanData.withPreserved(conn, (ResourceUser<? super DatabaseConnectionCore>)new ResourceUser<DatabaseConnectionCore>(){

            @Override
            public void use(DatabaseConnectionCore resource) throws PlanRetrievalException, SQLException {
                try (ReusableSmartStatement statement = SmartStatementFactoryService.getInstance().poweredBy(conn).simple().reuse();){
                    user.use(statement);
                }
            }
        }, savers);
    }

    @NotNull
    private static ThrowableConsumer<RemoteResultSet, Exception> planConsumer(@NotNull ThrowableConsumer<? super RemoteResultSet, ? extends Exception> consumer) {
        if (consumer == null) {
            RawPlanData.$$$reportNull$$$0(0);
        }
        ThrowableConsumer throwableConsumer = rs -> {
            try {
                consumer.consume(rs);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PlanRetrievalException("Failed to process plan query results", (Throwable)e);
            }
        };
        if (throwableConsumer == null) {
            RawPlanData.$$$reportNull$$$0(1);
        }
        return throwableConsumer;
    }

    @NotNull
    protected static ResultsProducer.VoidReadyProcessor<Unit> processing(@NotNull ThrowableConsumer<? super RemoteResultSet, ? extends Exception> consumer) {
        if (consumer == null) {
            RawPlanData.$$$reportNull$$$0(2);
        }
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = StandardResultsProcessors.results(RawPlanData.planConsumer(consumer), () -> RawPlanData.failWithEmptyResultSetError());
        if (voidReadyProcessor == null) {
            RawPlanData.$$$reportNull$$$0(3);
        }
        return voidReadyProcessor;
    }

    @NotNull
    protected static Consumer<ResultsProducer> processingAll(@NotNull ThrowableConsumer<? super RemoteResultSet, ? extends Exception> consumer) {
        if (consumer == null) {
            RawPlanData.$$$reportNull$$$0(4);
        }
        Consumer consumer2 = producer -> {
            Ref hasResult = new Ref((Object)false);
            producer.processRemaining((ResultsProducer.Processor)StandardResultsProcessors.results(RawPlanData.planConsumer((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)((ThrowableConsumer)rs -> {
                consumer.consume(rs);
                hasResult.set((Object)true);
            }))));
            if (!((Boolean)hasResult.get()).booleanValue()) {
                RawPlanData.failWithEmptyResultSetError();
            }
        };
        if (consumer2 == null) {
            RawPlanData.$$$reportNull$$$0(5);
        }
        return consumer2;
    }

    protected static void failWithEmptyResultSetError() {
        throw new PlanRetrievalException("No data returned for plan query");
    }

    protected static void withPreserved(DatabaseConnectionCore conn, ResourceUser<? super DatabaseConnectionCore> user, StateSaver ... savers) throws PlanRetrievalException {
        int preserved = 0;
        for (StateSaver saver : savers) {
            ++preserved;
            saver.save(conn);
        }
        try {
            user.use((DatabaseConnectionCore)conn);
        }
        catch (SQLException ignore) {
            throw new ProcessCanceledException();
        }
        finally {
            for (int i = preserved - 1; i >= 0; --i) {
                try {
                    savers[i].restore(conn);
                    continue;
                }
                catch (Exception e) {
                    AbstractPlanModelBuilder.LOG.warn((Throwable)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "planConsumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processingAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "planConsumer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processingAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }

    protected static interface ResourceUser<T> {
        public void use(T var1) throws PlanRetrievalException, SQLException;
    }

    protected static interface StateSaver {
        public void save(DatabaseConnectionCore var1) throws PlanRetrievalException;

        public void restore(DatabaseConnectionCore var1);
    }
}

