/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.ext;

import com.intellij.flyway.ext.MigrationVersion;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ResourceName {
    private final String prefix;
    private final String version;
    private final String separator;
    private final String description;
    private final String suffix;
    private String rawResourceName;

    public ResourceName(String prefix, String version, String separator, String description, String suffix, String rawResourceName) {
        this.prefix = prefix;
        this.version = version;
        this.separator = separator;
        this.description = description;
        this.suffix = suffix;
        this.rawResourceName = rawResourceName;
    }

    public String getRawResourceName() {
        return this.rawResourceName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private boolean isVersioned() {
        return !"".equals(this.version);
    }

    @Nullable
    public MigrationVersion getVersion() {
        if (this.isVersioned()) {
            return MigrationVersion.fromVersion(this.version);
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getFilenameWithoutSuffix() {
        if ("".equals(this.description)) {
            return this.prefix + this.version;
        }
        return this.prefix + this.version + this.separator + this.description;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toString() {
        return this.rawResourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceName that = (ResourceName)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.version, that.version) && Objects.equals(this.separator, that.separator) && Objects.equals(this.description, that.description) && Objects.equals(this.suffix, that.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.version, this.separator, this.description, this.suffix);
    }
}

