/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.jetbrains.relocated.apache.batik.ext.awt.g2d.GraphicContext;
import org.jetbrains.relocated.apache.batik.svggen.AbstractSVGConverter;
import org.jetbrains.relocated.apache.batik.svggen.ClipKey;
import org.jetbrains.relocated.apache.batik.svggen.SVGClipDescriptor;
import org.jetbrains.relocated.apache.batik.svggen.SVGDescriptor;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGShape;
import org.w3c.dom.Element;

public class SVGClip
extends AbstractSVGConverter {
    public static final Shape ORIGIN = new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public static final SVGClipDescriptor NO_CLIP = new SVGClipDescriptor("none", null);
    private SVGShape shapeConverter;

    public SVGClip(SVGGeneratorContext generatorContext) {
        super(generatorContext);
        this.shapeConverter = new SVGShape(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        Shape clip2 = gc.getClip();
        SVGClipDescriptor clipDesc = null;
        if (clip2 != null) {
            StringBuffer clipPathAttrBuf = new StringBuffer("url(");
            GeneralPath clipPath = new GeneralPath(clip2);
            ClipKey clipKey = new ClipKey(clipPath, this.generatorContext);
            clipDesc = (SVGClipDescriptor)this.descMap.get(clipKey);
            if (clipDesc == null) {
                Element clipDef = this.clipToSVG(clip2);
                if (clipDef == null) {
                    clipDesc = NO_CLIP;
                } else {
                    clipPathAttrBuf.append("#");
                    clipPathAttrBuf.append(clipDef.getAttributeNS(null, "id"));
                    clipPathAttrBuf.append(")");
                    clipDesc = new SVGClipDescriptor(clipPathAttrBuf.toString(), clipDef);
                    this.descMap.put(clipKey, clipDesc);
                    this.defSet.add(clipDef);
                }
            }
        } else {
            clipDesc = NO_CLIP;
        }
        return clipDesc;
    }

    private Element clipToSVG(Shape clip2) {
        Element clipDef = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "clipPath");
        clipDef.setAttributeNS(null, "clipPathUnits", "userSpaceOnUse");
        clipDef.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("clipPath"));
        Element clipPath = this.shapeConverter.toSVG(clip2);
        if (clipPath != null) {
            clipDef.appendChild(clipPath);
            return clipDef;
        }
        clipDef.appendChild(this.shapeConverter.toSVG(ORIGIN));
        return clipDef;
    }
}

