/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.theme.ExponentFormat;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.MarginalLayerUtil;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponent;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideKey;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideOptionsList;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssemblerPlotContext;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssemblerUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGeomTiles;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PositionalScalesUtil;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.BogusFrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.FrameOfReferenceProviderBase;
import org.jetbrains.letsPlot.core.plot.builder.frame.PolarFrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot.PlotFigureLayouter;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Style;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J.\u0010)\u001a\u00020*2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020,2\u0006\u00103\u001a\u000204R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler;", "", "geomTiles", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "xAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "yAxisPosition", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "title", "", "subtitle", "caption", "guideOptionsMap", "", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideKey;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideOptionsList;", "plotSpecId", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "containsLiveMap", "", "getContainsLiveMap", "()Z", "frameProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReferenceProvider;", "getGeomTiles", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "interactionsEnabled", "layouter", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayouter;", "legendsEnabled", "plotCaption", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "plotSubtitle", "plotTitle", "createPlot", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent;", "figureLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "styleSheet", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "disableInteractions", "", "disableLegends", "layoutByGeomSize", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "layoutByOuterSize", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotAssembler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssembler.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public final class PlotAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotGeomTiles geomTiles;
    @NotNull
    private final AxisPosition xAxisPosition;
    @NotNull
    private final AxisPosition yAxisPosition;
    @NotNull
    private final Theme theme;
    @Nullable
    private final String plotSpecId;
    @Nullable
    private final TimeZone tz;
    private final boolean containsLiveMap;
    @Nullable
    private final String plotTitle;
    @Nullable
    private final String plotSubtitle;
    @Nullable
    private final String plotCaption;
    private boolean legendsEnabled;
    private boolean interactionsEnabled;
    @NotNull
    private final List<FrameOfReferenceProvider> frameProviderByTile;
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final PlotFigureLayouter layouter;

    public PlotAssembler(@NotNull PlotGeomTiles geomTiles, @NotNull PlotFacets facets, @NotNull AxisPosition xAxisPosition, @NotNull AxisPosition yAxisPosition, @NotNull Theme theme2, @Nullable String title, @Nullable String subtitle, @Nullable String caption, @NotNull Map<GuideKey, GuideOptionsList> guideOptionsMap, @Nullable String plotSpecId, @Nullable TimeZone tz) {
        Pair pair2;
        boolean flipAxis;
        String string;
        String string2;
        String it;
        String string3;
        boolean bl;
        PlotAssembler plotAssembler;
        String string4;
        Intrinsics.checkNotNullParameter((Object)geomTiles, (String)"geomTiles");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)((Object)xAxisPosition), (String)"xAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)yAxisPosition), (String)"yAxisPosition");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        this.geomTiles = geomTiles;
        this.xAxisPosition = xAxisPosition;
        this.yAxisPosition = yAxisPosition;
        this.theme = theme2;
        this.plotSpecId = plotSpecId;
        this.tz = tz;
        this.containsLiveMap = this.geomTiles.getContainsLiveMap();
        PlotAssembler plotAssembler2 = this;
        String string5 = title;
        if (string5 != null) {
            String string6 = string4 = string5;
            plotAssembler = plotAssembler2;
            boolean bl2 = false;
            bl = this.theme.plot().showTitle();
            plotAssembler2 = plotAssembler;
            string3 = bl ? string4 : null;
        } else {
            string3 = null;
        }
        plotAssembler2.plotTitle = string3;
        PlotAssembler plotAssembler3 = this;
        String string7 = subtitle;
        if (string7 != null) {
            it = string4 = string7;
            plotAssembler = plotAssembler3;
            boolean bl3 = false;
            bl = this.theme.plot().showSubtitle();
            plotAssembler3 = plotAssembler;
            string2 = bl ? string4 : null;
        } else {
            string2 = null;
        }
        plotAssembler3.plotSubtitle = string2;
        PlotAssembler plotAssembler4 = this;
        String string8 = caption;
        if (string8 != null) {
            it = string4 = string8;
            plotAssembler = plotAssembler4;
            boolean bl4 = false;
            bl = this.theme.plot().showCaption();
            plotAssembler4 = plotAssembler;
            string = bl ? string4 : null;
        } else {
            string = null;
        }
        plotAssembler4.plotCaption = string;
        this.legendsEnabled = true;
        this.interactionsEnabled = true;
        this.plotContext = new PlotAssemblerPlotContext(this.geomTiles, Companion.extractExponentFormat(this.theme.getExponentFormat()), this.tz);
        List<LegendBoxInfo> legendBoxInfos = this.legendsEnabled ? PlotAssemblerUtil.INSTANCE.createLegends(this.plotContext, this.geomTiles, this.geomTiles.getMappersNP(), guideOptionsMap, this.theme.legend(), this.theme.panel()) : CollectionsKt.emptyList();
        boolean bl5 = flipAxis = this.geomTiles.getCoordProvider().getFlipped();
        if (bl5) {
            pair2 = TuplesKt.to((Object)((Object)this.yAxisPosition.flip()), (Object)((Object)this.xAxisPosition.flip()));
        } else if (!bl5) {
            pair2 = TuplesKt.to((Object)((Object)this.xAxisPosition), (Object)((Object)this.yAxisPosition));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair3 = pair2;
        AxisPosition hAxisPosition = (AxisPosition)((Object)pair3.component1());
        AxisPosition vAxisPosition = (AxisPosition)((Object)pair3.component2());
        List<Scale> scaleXByTile = this.geomTiles.scaleXByTile();
        List<Scale> scaleYByTile = this.geomTiles.scaleYByTile();
        List<Pair<DoubleSpan, DoubleSpan>> transformedDomainsXYByTile = this.geomTiles.getContainsLiveMap() ? null : PositionalScalesUtil.INSTANCE.computePlotXYTransformedDomains(this.geomTiles.coreLayersByTile(), scaleXByTile, scaleYByTile, facets, this.geomTiles.getCoordProvider());
        this.frameProviderByTile = PlotAssembler.Companion.frameProviderByTile(this.geomTiles.coreLayersByTile(), this.geomTiles.marginalLayersByTile(), this.geomTiles.getCoordProvider(), scaleXByTile, scaleYByTile, transformedDomainsXYByTile, this.geomTiles.getContainsLiveMap(), hAxisPosition, vAxisPosition, this.theme, this.plotContext);
        this.layouter = new PlotFigureLayouter(this.frameProviderByTile, facets, this.geomTiles.getCoordProvider(), this.geomTiles.getContainsLiveMap(), this.theme, legendBoxInfos, this.plotTitle, this.plotSubtitle, this.plotCaption);
    }

    public /* synthetic */ PlotAssembler(PlotGeomTiles plotGeomTiles, PlotFacets plotFacets, AxisPosition axisPosition, AxisPosition axisPosition2, Theme theme2, String string, String string2, String string3, Map map2, String string4, TimeZone timeZone, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        if ((n & 0x100) != 0) {
            map2 = new HashMap();
        }
        this(plotGeomTiles, plotFacets, axisPosition, axisPosition2, theme2, string, string2, string3, map2, string4, timeZone);
    }

    @NotNull
    public final PlotGeomTiles getGeomTiles() {
        return this.geomTiles;
    }

    public final boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByOuterSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return this.layouter.layoutByOuterSize(size2);
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByGeomSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return this.layouter.layoutByGeomSize(size2);
    }

    @NotNull
    public final PlotSvgComponent createPlot(@NotNull PlotFigureLayoutInfo figureLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)figureLayoutInfo, (String)"figureLayoutInfo");
        return this.createPlot(this.frameProviderByTile, figureLayoutInfo, Style.INSTANCE.fromTheme(this.theme, this.geomTiles.getCoordProvider().getFlipped()), this.plotContext);
    }

    private final PlotSvgComponent createPlot(List<? extends FrameOfReferenceProvider> frameProviderByTile, PlotFigureLayoutInfo figureLayoutInfo, StyleSheet styleSheet, PlotContext plotContext) {
        return new PlotSvgComponent(this.plotTitle, this.plotSubtitle, this.plotCaption, this.geomTiles.coreLayersByTile(), this.geomTiles.marginalLayersByTile(), figureLayoutInfo, frameProviderByTile, this.geomTiles.getCoordProvider(), this.interactionsEnabled, this.plotSpecId, this.theme, styleSheet, plotContext);
    }

    public final void disableLegends() {
        this.legendsEnabled = false;
    }

    public final void disableInteractions() {
        this.interactionsEnabled = false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u009e\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00110\u00112\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00110\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\u001a\u0010\u001b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler$Companion;", "", "()V", "demoAndTest", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler;", "geomTiles", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "xAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "yAxisPosition", "extractExponentFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "exponentFormat", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ExponentFormat;", "frameProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReferenceProvider;", "coreLayersByTile", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "marginalLayersByTile", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "scaleXProtoByTile", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "scaleYProtoByTile", "rawXYTransformedDomainsByTile", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "containsLiveMap", "", "hAxisPosition", "vAxisPosition", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPlotAssembler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssembler.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1549#2:282\n1620#2,3:283\n1559#2:286\n1590#2,4:287\n1559#2:291\n1590#2,4:292\n*S KotlinDebug\n*F\n+ 1 PlotAssembler.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler$Companion\n*L\n211#1:282\n211#1:283,3\n220#1:286\n220#1:287,4\n237#1:291\n237#1:292,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlotAssembler demoAndTest(@NotNull PlotGeomTiles geomTiles, @NotNull Theme theme2, @NotNull AxisPosition xAxisPosition, @NotNull AxisPosition yAxisPosition) {
            Intrinsics.checkNotNullParameter((Object)geomTiles, (String)"geomTiles");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)((Object)xAxisPosition), (String)"xAxisPosition");
            Intrinsics.checkNotNullParameter((Object)((Object)yAxisPosition), (String)"yAxisPosition");
            return new PlotAssembler(geomTiles, PlotFacets.Companion.getUNDEFINED(), xAxisPosition, yAxisPosition, theme2, null, null, null, null, null, null, 480, null);
        }

        public static /* synthetic */ PlotAssembler demoAndTest$default(Companion companion, PlotGeomTiles plotGeomTiles, Theme theme2, AxisPosition axisPosition, AxisPosition axisPosition2, int n, Object object) {
            if ((n & 4) != 0) {
                axisPosition = AxisPosition.BOTTOM;
            }
            if ((n & 8) != 0) {
                axisPosition2 = AxisPosition.LEFT;
            }
            return companion.demoAndTest(plotGeomTiles, theme2, axisPosition, axisPosition2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<FrameOfReferenceProvider> frameProviderByTile(List<? extends List<? extends GeomLayer>> coreLayersByTile, List<? extends List<? extends GeomLayer>> marginalLayersByTile, CoordProvider coordProvider, List<? extends Scale> scaleXProtoByTile, List<? extends Scale> scaleYProtoByTile, List<Pair<DoubleSpan, DoubleSpan>> rawXYTransformedDomainsByTile, boolean containsLiveMap, AxisPosition hAxisPosition, AxisPosition vAxisPosition, Theme theme2, PlotContext plotContext) {
            void $this$mapIndexedTo$iv$iv;
            Collection collection;
            void $this$mapIndexedTo$iv$iv2;
            if (containsLiveMap) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = coreLayersByTile;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    List list2 = (List)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new BogusFrameOfReferenceProvider());
                }
                return (List)destination$iv$iv;
            }
            List<Pair<DoubleSpan, DoubleSpan>> list3 = rawXYTransformedDomainsByTile;
            Intrinsics.checkNotNull(list3);
            List<Pair<DoubleSpan, DoubleSpan>> domainsXYByTile = list3;
            boolean flipAxis = coordProvider.getFlipped();
            Iterable $this$mapIndexed$iv = marginalLayersByTile;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                void tileIndex;
                void tileMarginalLayers;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list4 = (List)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MarginalLayerUtil.INSTANCE.marginalDomainByMargin((List<? extends GeomLayer>)tileMarginalLayers, scaleXProtoByTile.get((int)tileIndex), scaleYProtoByTile.get((int)tileIndex), coordProvider));
            }
            List domainByMarginByTile = (List)destination$iv$iv;
            GeomMarginsLayout marginsLayout = GeomMarginsLayout.Companion.create(marginalLayersByTile.get(0));
            Pair pair2 = flipAxis ? TuplesKt.to(scaleYProtoByTile, scaleXProtoByTile) : TuplesKt.to(scaleXProtoByTile, scaleYProtoByTile);
            List hScaleProtoByTile = (List)pair2.component1();
            List vScaleProtoByTile = (List)pair2.component2();
            Iterable $this$mapIndexed$iv2 = domainsXYByTile;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                FrameOfReferenceProviderBase frameOfReferenceProviderBase;
                void tileIndex;
                int n;
                if ((n = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair3 = (Pair)item$iv$iv;
                int n3 = n;
                collection = destination$iv$iv2;
                boolean bl = false;
                DoubleSpan xDomain = (DoubleSpan)pair3.component1();
                DoubleSpan yDomain = (DoubleSpan)pair3.component2();
                DoubleRectangle adjustedDomain = coordProvider.adjustDomain(new DoubleRectangle(xDomain, yDomain));
                if (coordProvider.isPolar()) {
                    DoubleRectangle adjustedDomainForPolar = adjustedDomain.flipIf(flipAxis);
                    frameOfReferenceProviderBase = new PolarFrameOfReferenceProvider(plotContext, (Scale)hScaleProtoByTile.get((int)tileIndex), (Scale)vScaleProtoByTile.get((int)tileIndex), adjustedDomainForPolar, flipAxis, theme2, marginsLayout, (Map)domainByMarginByTile.get((int)tileIndex));
                } else {
                    frameOfReferenceProviderBase = new SquareFrameOfReferenceProvider(plotContext, (Scale)hScaleProtoByTile.get((int)tileIndex), (Scale)vScaleProtoByTile.get((int)tileIndex), adjustedDomain, flipAxis, hAxisPosition, vAxisPosition, theme2, marginsLayout, (Map)domainByMarginByTile.get((int)tileIndex));
                }
                collection.add(frameOfReferenceProviderBase);
            }
            return (List)destination$iv$iv2;
        }

        @NotNull
        public final StringFormat.ExponentFormat extractExponentFormat(@NotNull ExponentFormat exponentFormat) {
            NumberFormat.ExponentNotationType exponentNotationType;
            Intrinsics.checkNotNullParameter((Object)exponentFormat, (String)"exponentFormat");
            switch (WhenMappings.$EnumSwitchMapping$0[exponentFormat.getNotationType().ordinal()]) {
                case 1: {
                    exponentNotationType = NumberFormat.ExponentNotationType.E;
                    break;
                }
                case 2: {
                    exponentNotationType = NumberFormat.ExponentNotationType.POW;
                    break;
                }
                case 3: {
                    exponentNotationType = NumberFormat.ExponentNotationType.POW_FULL;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            NumberFormat.ExponentNotationType notationType = exponentNotationType;
            return new StringFormat.ExponentFormat(notationType, exponentFormat.getMin(), exponentFormat.getMax());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExponentFormat.NotationType.values().length];
                try {
                    nArray[ExponentFormat.NotationType.E.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExponentFormat.NotationType.POW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExponentFormat.NotationType.POW_FULL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

