/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification;", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "()V", "computeWeights", "", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "initTriangles", "Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$SortedList;", "Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "Companion", "SortedList", "Triangle", "plot-base"})
@SourceDebugExtension(value={"SMAP\nVisvalingamWhyattSimplification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisvalingamWhyattSimplification.kt\norg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1549#3:157\n1620#3,3:158\n1549#3:161\n1620#3,3:162\n1855#3,2:165\n*S KotlinDebug\n*F\n+ 1 VisvalingamWhyattSimplification.kt\norg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification\n*L\n46#1:157\n46#1:158,3\n47#1:161\n47#1:162,3\n55#1:165,2\n*E\n"})
public final class VisvalingamWhyattSimplification
implements PolylineSimplifier.RankingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double INITIAL_AREA = Double.MAX_VALUE;

    @Override
    @NotNull
    public List<Double> computeWeights(@NotNull List<DoubleVector> points2) {
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        if (points2.size() < 3) {
            int n = points2.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add((Double)Double.MAX_VALUE);
            }
            return arrayList;
        }
        SortedList<Triangle> sortedTriangles = this.initTriangles(points2);
        int n = points2.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int it = 0;
        while (it < n) {
            int n5;
            int n6 = n5 = it++;
            ArrayList<Double> arrayList3 = arrayList;
            boolean bl = false;
            arrayList3.add((Double)Double.MAX_VALUE);
        }
        List weights = arrayList;
        double lastRemovedVertexArea = 0.0;
        while (!sortedTriangles.isEmpty()) {
            Triangle it2;
            Triangle triangle = sortedTriangles.poll$plot_base();
            lastRemovedVertexArea = Math.max(triangle.getArea(), lastRemovedVertexArea);
            weights.set(triangle.getCurrentVertex(), lastRemovedVertexArea);
            if (triangle.getNext() != null) {
                boolean bl = false;
                it2.takePrevFrom(triangle);
                sortedTriangles.reposition(it2);
            }
            if (triangle.getPrev() == null) continue;
            boolean bl = false;
            it2.takeNextFrom(triangle);
            sortedTriangles.reposition(it2);
        }
        return weights;
    }

    /*
     * WARNING - void declaration
     */
    private final SortedList<Triangle> initTriangles(List<DoubleVector> points2) {
        SortedList<Triangle> sortedList;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)1, (int)CollectionsKt.getLastIndex(points2));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triangle((int)i, points2));
        }
        List triangles = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.windowed$default((Iterable)triangles, (int)3, (int)0, (boolean)false, (int)6, null);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List i = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Triangle prev = (Triangle)i.get(0);
            Triangle current = (Triangle)i.get(1);
            Triangle next = (Triangle)i.get(2);
            prev.setNext(current);
            current.setPrev(prev);
            current.setNext(next);
            next.setPrev(current);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        SortedList<Triangle> $this$initTriangles_u24lambda_u247 = sortedList = new SortedList<Triangle>(new Comparator(){

            public final int compare(T a2, T b2) {
                Triangle p0 = (Triangle)a2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(p0.getArea());
                p0 = (Triangle)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(p0.getArea()));
            }
        });
        boolean bl = false;
        Iterable $this$forEach$iv = triangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triangle p0 = (Triangle)element$iv;
            boolean bl2 = false;
            $this$initTriangles_u24lambda_u247.add(p0);
        }
        return sortedList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Companion;", "", "()V", "INITIAL_AREA", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000f\u0010\u0012\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0013\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$SortedList;", "T", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "elements", "", "add", "", "el", "(Ljava/lang/Object;)V", "getIndex", "", "(Ljava/lang/Object;)I", "isEmpty", "", "peek", "peek$plot_base", "()Ljava/lang/Object;", "poll", "poll$plot_base", "remove", "reposition", "plot-base"})
    public static final class SortedList<T> {
        @NotNull
        private final Comparator<T> comparator;
        @NotNull
        private final List<T> elements;

        public SortedList(@NotNull Comparator<T> comparator2) {
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            this.comparator = comparator2;
            this.elements = new ArrayList();
        }

        public final boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public final T peek$plot_base() {
            return this.elements.get(0);
        }

        public final T poll$plot_base() {
            T el = this.peek$plot_base();
            this.elements.remove(el);
            return el;
        }

        private final int getIndex(T el) {
            int index = CollectionsKt.binarySearch$default(this.elements, el, this.comparator, (int)0, (int)0, (int)12, null);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
            return index;
        }

        public final void add(T el) {
            int index = this.getIndex(el);
            this.elements.add(index, el);
        }

        public final void remove(T el) {
            this.elements.remove(el);
        }

        public final void reposition(T el) {
            this.remove(el);
            this.add(el);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\tH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020 H\u0016R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "", "currentVertex", "", "points", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(ILjava/util/List;)V", "<set-?>", "", "area", "getArea", "()D", "getCurrentVertex", "()I", "next", "getNext", "()Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "setNext", "(Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;)V", "nextVertex", "prev", "getPrev", "setPrev", "prevVertex", "calculateArea", "min", "takeNextFrom", "", "triangle", "takePrevFrom", "toString", "", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nVisvalingamWhyattSimplification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisvalingamWhyattSimplification.kt\norg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
    private static final class Triangle {
        private final int currentVertex;
        @NotNull
        private final List<DoubleVector> points;
        private double area;
        private int prevVertex;
        private int nextVertex;
        @Nullable
        private Triangle prev;
        @Nullable
        private Triangle next;

        public Triangle(int currentVertex, @NotNull List<DoubleVector> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            this.currentVertex = currentVertex;
            this.points = points2;
            this.prevVertex = this.currentVertex - 1;
            this.nextVertex = this.currentVertex + 1;
            this.area = Triangle.calculateArea$default(this, 0.0, 1, null);
        }

        public final int getCurrentVertex() {
            return this.currentVertex;
        }

        public final double getArea() {
            return this.area;
        }

        @Nullable
        public final Triangle getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Triangle triangle) {
            this.prev = triangle;
        }

        @Nullable
        public final Triangle getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Triangle triangle) {
            this.next = triangle;
        }

        public final void takeNextFrom(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.next = triangle.next;
            this.nextVertex = triangle.nextVertex;
            this.area = this.calculateArea(triangle.area);
        }

        public final void takePrevFrom(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.prev = triangle.prev;
            this.prevVertex = triangle.prevVertex;
            this.area = this.calculateArea(triangle.area);
        }

        private final double calculateArea(double min) {
            DoubleVector doubleVector = this.points.get(this.prevVertex);
            double x1 = doubleVector.component1();
            double y1 = doubleVector.component2();
            DoubleVector doubleVector2 = this.points.get(this.currentVertex);
            double x2 = doubleVector2.component1();
            double y2 = doubleVector2.component2();
            DoubleVector doubleVector3 = this.points.get(this.nextVertex);
            double x3 = doubleVector3.component1();
            double y3 = doubleVector3.component2();
            double area2 = Math.abs((x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2)) / 2.0);
            Double d = area2;
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            Double d2 = it > min ? d : null;
            return d2 != null ? d2 : min + Double.MIN_VALUE;
        }

        static /* synthetic */ double calculateArea$default(Triangle triangle, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = 0.0;
            }
            return triangle.calculateArea(d);
        }

        @NotNull
        public String toString() {
            return "Triangle{prevVertex=" + this.prevVertex + ", currentVertex=" + this.currentVertex + ", nextVertex=" + this.nextVertex + ", area=" + this.area + '}';
        }
    }
}

