/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

final class CharacterDataParser {
    private static final boolean DEBUG = false;
    private State state = State.SEGMENT_START;
    private StringBuilder buffer = new StringBuilder();
    private char[] data;
    private int begin;
    private int end;

    CharacterDataParser() {
    }

    public void append(char[] ch, int offset, int length) {
        int segmentBreaks;
        if (length == 0) {
            return;
        }
        this.data = ch;
        this.begin = offset;
        this.end = offset + length;
        if (CharacterDataParser.isSegmentBreak(this.data[this.begin])) {
            segmentBreaks = this.trimLeadingWhiteSpace();
            if (this.state == State.SEGMENT_BREAK) {
                ++segmentBreaks;
            }
            if (this.begin > offset && segmentBreaks > 1) {
                --this.begin;
                this.data[this.begin] = 32;
                if (this.state == State.CHARACTER || this.state == State.SEGMENT_BREAK) {
                    this.state = State.WHITESPACE_AFTER_CHAR;
                }
            }
        }
        segmentBreaks = this.trimTrailingWhiteSpace();
        if (this.end < offset + length) {
            this.data[this.end] = segmentBreaks > 0 ? 10 : 32;
            ++this.end;
        }
        if (this.begin >= this.end) {
            return;
        }
        this.buffer.ensureCapacity(this.buffer.length() + this.end - this.begin);
        this.appendData();
    }

    private void appendData() {
        int initialOffset = this.begin;
        while (this.begin < this.end) {
            char c = this.data[this.begin];
            boolean segmentBreak = CharacterDataParser.isSegmentBreak(c);
            boolean whiteSpace = CharacterDataParser.isWhitespace(c);
            if (!segmentBreak && !whiteSpace) {
                if (this.state == State.WHITESPACE_AFTER_CHAR || this.state.isVisualSpace && this.begin > initialOffset) {
                    this.buffer.append(' ');
                }
                this.state = State.CHARACTER;
                this.buffer.append(c);
            } else if (whiteSpace) {
                switch (this.state) {
                    case CHARACTER: 
                    case WHITESPACE_AFTER_CHAR: {
                        this.state = State.WHITESPACE_AFTER_CHAR;
                        break;
                    }
                    case SEGMENT_BREAK: 
                    case WHITESPACE_AFTER_SEGMENT_BREAK: {
                        this.state = State.WHITESPACE_AFTER_SEGMENT_BREAK;
                        break;
                    }
                }
            } else {
                this.state = State.SEGMENT_BREAK;
            }
            ++this.begin;
        }
    }

    public boolean canFlush(boolean dueToSegmentBreak) {
        if (this.state == State.SEGMENT_START) {
            return false;
        }
        return dueToSegmentBreak || this.buffer.length() > 0;
    }

    public char[] flush(boolean dueToSegmentBreak) {
        if (dueToSegmentBreak && this.state != State.CHARACTER) {
            this.buffer.append(' ');
        }
        if (dueToSegmentBreak) {
            this.state = State.SEGMENT_BREAK;
        }
        char[] ch = new char[this.buffer.length()];
        this.buffer.getChars(0, ch.length, ch, 0);
        this.buffer = new StringBuilder();
        return ch;
    }

    private int trimLeadingWhiteSpace() {
        int segmentBreakCount = 0;
        while (this.begin < this.end) {
            if (CharacterDataParser.isSegmentBreak(this.data[this.begin])) {
                ++segmentBreakCount;
                ++this.begin;
                continue;
            }
            if (!CharacterDataParser.isWhitespace(this.data[this.begin])) break;
            ++this.begin;
        }
        return segmentBreakCount;
    }

    private int trimTrailingWhiteSpace() {
        int segmentBreakCount = 0;
        while (this.begin < this.end) {
            if (CharacterDataParser.isSegmentBreak(this.data[this.end - 1])) {
                ++segmentBreakCount;
                --this.end;
                continue;
            }
            if (!CharacterDataParser.isWhitespace(this.data[this.end - 1])) break;
            --this.end;
        }
        return segmentBreakCount;
    }

    private static boolean isSegmentBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private static enum State {
        SEGMENT_START(false),
        SEGMENT_BREAK(true),
        WHITESPACE_AFTER_CHAR(true),
        WHITESPACE_AFTER_SEGMENT_BREAK(true),
        CHARACTER(false);

        private final boolean isVisualSpace;

        private State(boolean isVisualSpace) {
            this.isVisualSpace = isVisualSpace;
        }
    }
}

