/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl.inspections;

import com.goide.template.GoTemplateTypes;
import com.goide.template.psi.GoTemplatePipelineStatement;
import com.goide.template.psi.GoTemplateStatement;
import com.goide.template.psi.GoTemplateVisitor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.helm.gotpl.GoTemplateUtilKt;
import com.intellij.kubernetes.helm.gotpl.i18n.ChartsGoTemplateBundle;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/inspections/ExcessiveWhitespaceTrimInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveLeftWhiteSpaceTrim", "RemoveRightWhiteSpaceTrim", "intellij.clouds.kubernetes.charts.gotpl"})
public final class ExcessiveWhitespaceTrimInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new GoTemplateVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitStatement(GoTemplateStatement o) {
                List quickFixes;
                LocalQuickFix[] localQuickFixArray;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                ASTNode aSTNode = o.getNode();
                if (aSTNode == null || (aSTNode = aSTNode.findChildByType(GoTemplateTypes.LDOUBLE_BRACE)) == null) {
                    return;
                }
                ASTNode leftBrace = aSTNode;
                ASTNode aSTNode2 = o.getNode();
                if (aSTNode2 == null || (aSTNode2 = aSTNode2.findChildByType(GoTemplateTypes.RDOUBLE_BRACE)) == null) {
                    return;
                }
                ASTNode rightBrace = aSTNode2;
                boolean hasLeftTrim = leftBrace.textContains('-');
                boolean hasRightTrim = rightBrace.textContains('-');
                if (!hasLeftTrim && !hasRightTrim) {
                    return;
                }
                boolean hasNonEmptyElementsBefore = PsiTreeUtil.prevCodeLeaf((PsiElement)leftBrace.getPsi()) != null;
                boolean hasNonEmptyElementsAfter = PsiTreeUtil.nextCodeLeaf((PsiElement)rightBrace.getPsi()) != null;
                if (o instanceof GoTemplatePipelineStatement) {
                    LocalQuickFix[] $this$visitStatement_u24lambda_u240 = localQuickFixArray = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    if (hasLeftTrim && hasNonEmptyElementsBefore) {
                        UtilKt.addIfNotNull((List)$this$visitStatement_u24lambda_u240, (Object)LocalQuickFix.from((ModCommandAction)((ModCommandAction)new RemoveLeftWhiteSpaceTrim())));
                    }
                    if (hasRightTrim && hasNonEmptyElementsAfter) {
                        UtilKt.addIfNotNull((List)$this$visitStatement_u24lambda_u240, (Object)LocalQuickFix.from((ModCommandAction)((ModCommandAction)new RemoveRightWhiteSpaceTrim())));
                    }
                    v2 = CollectionsKt.build((List)localQuickFixArray);
                } else if (hasLeftTrim && hasRightTrim && hasNonEmptyElementsBefore && hasNonEmptyElementsAfter) {
                    LocalQuickFix[] $this$visitStatement_u24lambda_u241 = localQuickFixArray = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    Object[] objectArray = new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)((ModCommandAction)new RemoveLeftWhiteSpaceTrim())), LocalQuickFix.from((ModCommandAction)((ModCommandAction)new RemoveRightWhiteSpaceTrim()))};
                    UtilKt.addAllIfNotNull((List)$this$visitStatement_u24lambda_u241, (Object[])objectArray);
                    v2 = CollectionsKt.build((List)localQuickFixArray);
                } else {
                    v2 = quickFixes = CollectionsKt.emptyList();
                }
                if (!((Collection)quickFixes).isEmpty()) {
                    Collection $this$toTypedArray$iv = quickFixes;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                    this.$holder.registerProblem((PsiElement)o, TextRange.from((int)leftBrace.getStartOffsetInParent(), (int)(rightBrace.getStartOffsetInParent() + rightBrace.getTextLength())), ChartsGoTemplateBundle.message("ExcessiveWhitespaceTrimInspection.display.name", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/inspections/ExcessiveWhitespaceTrimInspection$RemoveLeftWhiteSpaceTrim;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/goide/template/psi/GoTemplateStatement;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "perform", "Lcom/intellij/modcommand/ModCommand;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "intellij.clouds.kubernetes.charts.gotpl"})
    private static final class RemoveLeftWhiteSpaceTrim
    extends PsiBasedModCommandAction<GoTemplateStatement> {
        public RemoveLeftWhiteSpaceTrim() {
            super(GoTemplateStatement.class);
        }

        @NotNull
        public String getFamilyName() {
            String string = ChartsGoTemplateBundle.message("ExcessiveWhitespaceModCommandAction.remove.trim.left", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull GoTemplateStatement element) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)element), arg_0 -> RemoveLeftWhiteSpaceTrim.perform$lambda$0(context, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }

        private static final void perform$lambda$0(ActionContext $context, GoTemplateStatement eCopy) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)eCopy, (String)"eCopy");
                Project project = $context.project();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
                PsiElement trimmedLBrace = GoTemplateUtilKt.createLDoubleBrace(project);
                ASTNode aSTNode = eCopy.getNode();
                if (aSTNode == null || (aSTNode = aSTNode.findChildByType(GoTemplateTypes.LDOUBLE_BRACE)) == null) {
                    return;
                }
                int lBraceOffset = aSTNode.getStartOffsetInParent();
                PsiElement psiElement = eCopy.findElementAt(lBraceOffset);
                if (psiElement == null) break block1;
                psiElement.replace(trimmedLBrace);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/inspections/ExcessiveWhitespaceTrimInspection$RemoveRightWhiteSpaceTrim;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/goide/template/psi/GoTemplateStatement;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "perform", "Lcom/intellij/modcommand/ModCommand;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "intellij.clouds.kubernetes.charts.gotpl"})
    private static final class RemoveRightWhiteSpaceTrim
    extends PsiBasedModCommandAction<GoTemplateStatement> {
        public RemoveRightWhiteSpaceTrim() {
            super(GoTemplateStatement.class);
        }

        @NotNull
        public String getFamilyName() {
            String string = ChartsGoTemplateBundle.message("ExcessiveWhitespaceModCommandAction.remove.trim.right", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull GoTemplateStatement element) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)element), arg_0 -> RemoveRightWhiteSpaceTrim.perform$lambda$0(context, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }

        private static final void perform$lambda$0(ActionContext $context, GoTemplateStatement eCopy) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)eCopy, (String)"eCopy");
                Project project = $context.project();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
                PsiElement trimmedRBrace = GoTemplateUtilKt.createRDoubleBrace(project);
                ASTNode aSTNode = eCopy.getNode();
                if (aSTNode == null || (aSTNode = aSTNode.findChildByType(GoTemplateTypes.RDOUBLE_BRACE)) == null) {
                    return;
                }
                int rBraceOffset = aSTNode.getStartOffsetInParent();
                PsiElement psiElement = eCopy.findElementAt(rBraceOffset);
                if (psiElement == null) break block1;
                psiElement.replace(trimmedRBrace);
            }
        }
    }
}

