/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00060\nj\u0002`\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\n\u0010\u000e\u001a\u00060\nj\u0002`\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorLexer;", "", "<init>", "()V", "tokenize", "", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorToken;", "selector", "", "addPendingToken", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "result", "", "currentSelector", "intellij.textmate.core"})
public final class TextMateSelectorLexer {
    @NotNull
    public static final TextMateSelectorLexer INSTANCE = new TextMateSelectorLexer();

    private TextMateSelectorLexer() {
    }

    @NotNull
    public final List<TextMateSelectorToken> tokenize(@NotNull CharSequence selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        List result = new ArrayList();
        StringBuilder currentSelector = new StringBuilder();
        for (int i = 0; i < selector.length(); ++i) {
            char c = selector.charAt(i);
            if (c == '(') {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getLPAREN());
                continue;
            }
            if (c == ')') {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getRPAREN());
                continue;
            }
            if (c == ',') {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getCOMMA());
                continue;
            }
            if (c == '|') {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getPIPE());
                continue;
            }
            if (c == '^') {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getHAT());
                continue;
            }
            if (c == '-' && ((CharSequence)currentSelector).length() == 0) {
                currentSelector = this.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.Companion.getMINUS());
                continue;
            }
            if (c == ' ') {
                currentSelector = this.addPendingToken(result, currentSelector);
                continue;
            }
            if ((c == 'R' || c == 'L' || c == 'B') && i + 1 < selector.length() && selector.charAt(i + 1) == ':') {
                currentSelector = this.addPendingToken(result, currentSelector);
                ++i;
                switch (c) {
                    case 'R': {
                        result.add(new TextMateSelectorToken.PriorityToken(TextMateWeigh.Priority.LOW));
                        break;
                    }
                    case 'L': {
                        result.add(new TextMateSelectorToken.PriorityToken(TextMateWeigh.Priority.HIGH));
                    }
                }
                continue;
            }
            currentSelector.append(c);
        }
        this.addPendingToken(result, currentSelector);
        return result;
    }

    private final StringBuilder addPendingToken(List<TextMateSelectorToken> result, StringBuilder currentSelector) {
        if (!(((CharSequence)currentSelector).length() == 0)) {
            String string = currentSelector.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result.add(new TextMateSelectorToken.SelectorToken(string));
            return new StringBuilder();
        }
        return currentSelector;
    }
}

