/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.StashInfo;
import git4idea.validators.GitBranchValidatorKt;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lgit4idea/stash/ui/GitUnstashAsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "stashInfo", "Lgit4idea/ui/StashInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/StashInfo;)V", "branchTextField", "Lcom/intellij/ui/components/JBTextField;", "popStashCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "keepIndexCheckbox", "value", "", "popStash", "getPopStash", "()Z", "keepIndex", "getKeepIndex", "", "branch", "getBranch", "()Ljava/lang/String;", "createCenterPanel", "Ljavax/swing/JComponent;", "onBranchChanged", "", "onPopStashChanged", "updateEnabled", "updateOkButtonText", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUnstashAsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUnstashAsDialog.kt\ngit4idea/stash/ui/GitUnstashAsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class GitUnstashAsDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final StashInfo stashInfo;
    private JBTextField branchTextField;
    private JBCheckBox popStashCheckbox;
    private JBCheckBox keepIndexCheckbox;
    private boolean popStash;
    private boolean keepIndex;
    @NotNull
    private String branch;

    public GitUnstashAsDialog(@NotNull Project project, @NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        super(project);
        this.project = project;
        this.stashInfo = stashInfo;
        this.branch = "";
        Object[] objectArray = new Object[]{this.stashInfo.getRoot().getPresentableName()};
        this.setTitle(GitBundle.message((String)"stash.unstash.changes.in.root.dialog.title", (Object[])objectArray));
        this.init();
        this.updateOkButtonText();
    }

    public final boolean getPopStash() {
        return this.popStash;
    }

    public final boolean getKeepIndex() {
        return this.keepIndex;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    private final void onBranchChanged() {
        this.updateEnabled();
        this.updateOkButtonText();
    }

    private final void onPopStashChanged() {
        this.updateOkButtonText();
    }

    private final void updateEnabled() {
        JBTextField jBTextField = this.branchTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"branchTextField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        boolean hasBranch = !StringsKt.isBlank((CharSequence)string);
        JBCheckBox jBCheckBox = this.popStashCheckbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popStashCheckbox");
            jBCheckBox = null;
        }
        jBCheckBox.setEnabled(!hasBranch);
        JBCheckBox jBCheckBox2 = this.keepIndexCheckbox;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepIndexCheckbox");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setEnabled(!hasBranch);
    }

    private final void updateOkButtonText() {
        String string;
        JBTextField jBTextField = this.branchTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"branchTextField");
            jBTextField = null;
        }
        String string2 = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (!StringsKt.isBlank((CharSequence)string2)) {
            string = GitBundle.message((String)"unstash.button.branch", (Object[])new Object[0]);
        } else {
            JBCheckBox jBCheckBox = this.popStashCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popStashCheckbox");
                jBCheckBox = null;
            }
            string = jBCheckBox.isSelected() ? GitBundle.message((String)"unstash.button.pop", (Object[])new Object[0]) : GitBundle.message((String)"unstash.button.apply", (Object[])new Object[0]);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String buttonText = string3;
        this.setOKButtonText(buttonText);
    }

    private static final Unit createCenterPanel$lambda$0(GitUnstashAsDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = GitBundle.message((String)"stash.unstash.changes.current.branch.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        String string2 = GitBundle.message((String)"unstash.branch.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$0$0(GitUnstashAsDialog this$0, Row $this$row) {
        Object object;
        Row row;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                row = $this$row;
                object = CurrentBranchComponent.Companion.getCurrentBranch(this$0.project, this$0.stashInfo.getRoot());
                if (object == null) break block2;
                BranchData branchData = object;
                Row row2 = row;
                boolean bl = false;
                String string = BranchPresentation.INSTANCE.getPresentableText((BranchData)it);
                row = row2;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        row.label((String)object);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(GitUnstashAsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.branchTextField = (JBTextField)TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((GitUnstashAsDialog)((Object)this.receiver)).getBranch();
            }

            public void set(Object value) {
                GitUnstashAsDialog.access$setBranch$p((GitUnstashAsDialog)((Object)this.receiver), (String)value);
            }
        })).validationOnInput((arg_0, arg_1) -> GitUnstashAsDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0, arg_1)).applyToComponent(arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$1$1(this$0, arg_0)).focused().getComponent();
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$0(GitUnstashAsDialog this$0, ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager(this$0.project).getRepositoryForRootQuick(this$0.stashInfo.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        Collection collection = CollectionsKt.listOf((Object)repository2);
        String string2 = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return GitBranchValidatorKt.validateName(collection, string2);
    }

    private static final Unit createCenterPanel$lambda$0$1$1(GitUnstashAsDialog this$0, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this$0){
            final /* synthetic */ GitUnstashAsDialog this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                GitUnstashAsDialog.access$onBranchChanged(this.this$0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(GitUnstashAsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GitBundle.message((String)"unstash.pop.stash", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.popStashCheckbox = (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string).applyToComponent(arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$2$0(this$0, arg_0)), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((GitUnstashAsDialog)((Object)this.receiver)).getPopStash();
            }

            public void set(Object value) {
                GitUnstashAsDialog.access$setPopStash$p((GitUnstashAsDialog)((Object)this.receiver), (Boolean)value);
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0(GitUnstashAsDialog this$0, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(GitBundle.message((String)"unstash.pop.stash.tooltip", (Object[])new Object[0]));
        $this$applyToComponent.addActionListener(arg_0 -> GitUnstashAsDialog.createCenterPanel$lambda$0$2$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$0$2$0$0(GitUnstashAsDialog this$0, ActionEvent it) {
        this$0.onPopStashChanged();
    }

    private static final Unit createCenterPanel$lambda$0$3(GitUnstashAsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GitBundle.message((String)"unstash.reinstate.index", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.keepIndexCheckbox = (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string).applyToComponent(GitUnstashAsDialog::createCenterPanel$lambda$0$3$0), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((GitUnstashAsDialog)((Object)this.receiver)).getKeepIndex();
            }

            public void set(Object value) {
                GitUnstashAsDialog.access$setKeepIndex$p((GitUnstashAsDialog)((Object)this.receiver), (Boolean)value);
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(GitBundle.message((String)"unstash.reinstate.index.tooltip", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setBranch$p(GitUnstashAsDialog $this, String string) {
        $this.branch = string;
    }

    public static final /* synthetic */ void access$onBranchChanged(GitUnstashAsDialog $this) {
        $this.onBranchChanged();
    }

    public static final /* synthetic */ void access$setPopStash$p(GitUnstashAsDialog $this, boolean bl) {
        $this.popStash = bl;
    }

    public static final /* synthetic */ void access$setKeepIndex$p(GitUnstashAsDialog $this, boolean bl) {
        $this.keepIndex = bl;
    }
}

