/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodParamTypeDeserializer;
import com.intellij.javaee.process.common.WrappedException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MethodParamDeserializer {
    private final Map<Class<?>, MethodParamTypeDeserializer<?>> myType2DeserializerMap = new HashMap();

    public MethodParamDeserializer() {
        this.addType(new MethodParamTypeDeserializer<String>(String.class){

            @Override
            public String deserializeParamValue(String paramValue) {
                return paramValue;
            }
        });
        this.addType(new MethodParamTypeDeserializer<Integer>(Integer.class){

            @Override
            public Integer deserializeParamValue(String paramValue) {
                return Integer.valueOf(paramValue);
            }
        });
        this.addType(new MethodParamTypeDeserializer<Integer>(Integer.TYPE){

            @Override
            public Integer deserializeParamValue(String paramValue) {
                return Integer.valueOf(paramValue);
            }
        });
        this.addType(new MethodParamTypeDeserializer<Boolean>(Boolean.class){

            @Override
            public Boolean deserializeParamValue(String paramValue) {
                return Boolean.valueOf(paramValue);
            }
        });
        this.addType(new MethodParamTypeDeserializer<Boolean>(Boolean.TYPE){

            @Override
            public Boolean deserializeParamValue(String paramValue) {
                return Boolean.valueOf(paramValue);
            }
        });
        this.addType(new MethodParamTypeDeserializer<File>(File.class){

            @Override
            public File deserializeParamValue(String paramValue) {
                return new File(paramValue);
            }
        });
        this.addType(new MethodParamTypeDeserializer<Exception>(Exception.class){

            @Override
            public Exception deserializeParamValue(String paramValue) {
                return WrappedException.deserialize(paramValue);
            }
        });
    }

    public void addType(MethodParamTypeDeserializer<?> typeDeserializer) {
        this.myType2DeserializerMap.put(typeDeserializer.getParamType(), typeDeserializer);
    }

    public Object deserialize(Class<?> paramType, String paramValue) throws JavaeeProcessUtilException {
        MethodParamTypeDeserializer<?> typeDeserializer = this.myType2DeserializerMap.get(paramType);
        if (typeDeserializer == null) {
            throw new JavaeeProcessUtilException("Unknown param type: " + paramType);
        }
        return typeDeserializer.deserializeParamValue(paramValue);
    }
}

