/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;

public abstract class SourceRootsSelectorConfigurable
implements UnnamedConfigurable {
    private final JPanel myMainPanel;
    private final JPanel myCheckBoxesPanel;
    private final FacetEditorContext myContext;
    protected final Map<String, JCheckBox> myUrl2CheckBox = new LinkedHashMap<String, JCheckBox>();

    public SourceRootsSelectorConfigurable(FacetEditorContext context, @Nls String title) {
        this.myContext = context;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        this.myCheckBoxesPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.myCheckBoxesPanel.setBackground(UIUtil.getListBackground());
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCheckBoxesPanel, (int)22, (int)30), "Center");
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Comparing.haveEqualElements(this.getSourceRootsConfiguration(), this.getConfiguredRoots());
    }

    protected abstract List<String> getSourceRootsConfiguration();

    protected List<String> getConfiguredRoots() {
        ArrayList<String> roots = new ArrayList<String>();
        for (Map.Entry<String, JCheckBox> entry : this.myUrl2CheckBox.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            roots.add(entry.getKey());
        }
        return roots;
    }

    public void reset() {
        this.updateRootsList();
        this.updateOccupiedRootsList();
        HashSet<String> roots = new HashSet<String>(this.getSourceRootsConfiguration());
        for (Map.Entry<String, JCheckBox> entry : this.myUrl2CheckBox.entrySet()) {
            entry.getValue().setSelected(roots.contains(entry.getKey()));
        }
        Dimension oldPreferredSize = this.myMainPanel.getPreferredSize();
        this.myMainPanel.setPreferredSize(new Dimension(oldPreferredSize.width, Math.min(oldPreferredSize.height, 200)));
    }

    protected void updateOccupiedRootsList() {
    }

    protected void updateRootsList() {
        String[] urls = this.myContext.getRootModel().getSourceRootUrls(false);
        HashSet<String> toRemove = new HashSet<String>(this.myUrl2CheckBox.keySet());
        boolean changed = false;
        for (String url : urls) {
            toRemove.remove(url);
            if (this.myUrl2CheckBox.containsKey(url)) continue;
            JCheckBox checkBox = this.createCheckBox(url);
            this.myUrl2CheckBox.put(url, checkBox);
            this.myCheckBoxesPanel.add(checkBox);
            changed = true;
        }
        for (String url : toRemove) {
            changed = true;
            JCheckBox checkBox = this.myUrl2CheckBox.remove(url);
            this.myCheckBoxesPanel.remove(checkBox);
        }
        if (changed) {
            this.myCheckBoxesPanel.revalidate();
            this.myCheckBoxesPanel.repaint();
        }
    }

    private JCheckBox createCheckBox(final String url) {
        String path = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        final JCheckBox checkBox = new JCheckBox(path);
        checkBox.setOpaque(false);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceRootsSelectorConfigurable.this.onCheckboxActionPerformed(checkBox, url);
            }
        });
        return checkBox;
    }

    protected void onCheckboxActionPerformed(JCheckBox checkBox, String url) {
    }
}

