/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.editor.JSBreadcrumbsProvider;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int myUsageCount = 1;
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private final boolean myNavigateToReference;

    public JSCallHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PsiElement element2, boolean isBase, boolean navigateToReference) {
        super(project, (NodeDescriptor)parentDescriptor, element2, isBase);
        this.myNavigateToReference = navigateToReference;
    }

    @Nullable
    public PsiElement getEnclosingElement() {
        PsiElement element2 = this.getPsiElement();
        return element2 == null ? null : JSCallHierarchyNodeDescriptor.getEnclosingElement(element2);
    }

    @Nullable
    static PsiElement getEnclosingElement(@NotNull PsiElement element2) {
        PsiFile containingFile;
        PsiElement psiElement;
        if (element2 == null) {
            JSCallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if ((psiElement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JSFunctionItem.class, JSClass.class, JSFile.class})) instanceof JSFile) {
            XmlFile xmlFile;
            PsiElement context2 = psiElement.getContext();
            if (context2 != null && (xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlFile.class)) != null) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)xmlFile);
            }
            return psiElement;
        }
        if (psiElement == null && (containingFile = element2.getContainingFile()) instanceof XmlFile) {
            return containingFile;
        }
        return psiElement;
    }

    public void incrementUsageCount() {
        ++this.myUsageCount;
    }

    public PsiElement getTargetElement() {
        return this.getPsiElement();
    }

    public boolean isValid() {
        return this.getEnclosingElement() != null;
    }

    public boolean update() {
        String packageName;
        String qName;
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        boolean changes = super.update();
        PsiElement enclosingElement = this.getEnclosingElement();
        if (enclosingElement == null) {
            return this.invalidElement();
        }
        this.installIcon(enclosingElement, changes);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (enclosingElement instanceof JSFunction) {
            JSFunction method = (JSFunction)enclosingElement;
            String methodText = JSBreadcrumbsProvider.getCallbackPresentation((PsiElement)method);
            if (methodText == null) {
                methodText = JSFormatUtil.formatMethod((JSFunction)method, (int)4353, (int)2);
            }
            this.myHighlightedText.getEnding().addText(methodText, mainTextAttributes);
        } else {
            this.myHighlightedText.getEnding().addText(((NavigationItem)enclosingElement).getName(), mainTextAttributes);
        }
        if (this.myUsageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.myUsageCount}), JSCallHierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        JSClass jsClass = enclosingElement instanceof JSFunction ? JSResolveUtil.getClassOfContext((PsiElement)enclosingElement) : (enclosingElement instanceof JSClass ? (JSClass)enclosingElement : null);
        String string = qName = jsClass == null ? null : jsClass.getQualifiedName();
        if (qName != null && !(packageName = StringUtil.getPackageName((String)qName)).isEmpty()) {
            this.myHighlightedText.getEnding().addText(" (" + packageName + ")", JSCallHierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public void navigate(boolean requestFocus) {
        if (!this.myNavigateToReference) {
            PsiElement element2 = this.getPsiElement();
            if (element2 instanceof Navigatable && ((Navigatable)element2).canNavigate()) {
                ((Navigatable)element2).navigate(requestFocus);
            }
            return;
        }
        PsiReference firstReference = this.myReferences.getFirst();
        PsiElement element3 = firstReference.getElement();
        PsiElement callElement = element3.getParent();
        if (callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate()) {
            ((Navigatable)callElement).navigate(requestFocus);
        } else {
            PsiFile psiFile = callElement.getContainingFile();
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(psiFile.getVirtualFile(), requestFocus);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        ArrayList highlighters = new ArrayList();
        for (PsiReference psiReference : this.myReferences) {
            Editor editor;
            PsiElement eachElement = psiReference.getElement();
            PsiElement eachMethodCall = eachElement.getParent();
            if (eachMethodCall == null || (editor = JSCallHierarchyNodeDescriptor.getEditor(eachMethodCall)) == null) continue;
            TextRange textRange = eachMethodCall.getTextRange();
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, highlighters);
        }
    }

    @Nullable
    private static Editor getEditor(PsiElement callElement) {
        if (!callElement.isValid()) {
            return null;
        }
        Editor editor = PsiEditorUtil.findEditor((PsiElement)callElement);
        if (editor == null) {
            return null;
        }
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)callElement.getContainingFile());
    }

    public boolean canNavigate() {
        PsiFile psiFile;
        if (!this.myNavigateToReference) {
            PsiElement element2 = this.getPsiElement();
            return element2 instanceof Navigatable && ((Navigatable)element2).canNavigate();
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        PsiReference firstReference = this.myReferences.getFirst();
        PsiElement callElement = firstReference.getElement().getParent();
        if (callElement == null || !callElement.isValid()) {
            return false;
        }
        return callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate() || (psiFile = callElement.getContainingFile()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyNodeDescriptor", "getEnclosingElement"));
    }
}

