/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.javascript.JSRunConfigurationBuilderBase;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfigurationBuilder
extends JSRunConfigurationBuilderBase<NpmRunConfiguration, NpmRunSettings> {
    public static final String NAME = "npm";
    public static final String RUN_SCRIPT = "run-script";

    public NpmRunConfigurationBuilder(@NotNull Project project) {
        if (project == null) {
            NpmRunConfigurationBuilder.$$$reportNull$$$0(0);
        }
        super(project, NAME, (ConfigurationType)NpmConfigurationType.getInstance(), NpmRunConfiguration::getRunSettings, NpmRunConfiguration::setRunSettings);
    }

    @Override
    @NotNull
    protected NpmRunSettings createRunSettings(@Nullable VirtualFile baseDir, @Nullable String configPath, @NotNull Map<String, Object> options) {
        if (options == null) {
            NpmRunConfigurationBuilder.$$$reportNull$$$0(1);
        }
        assert (configPath != null);
        String scriptName = (String)ObjectUtils.tryCast((Object)options.get(RUN_SCRIPT), String.class);
        if (scriptName == null) {
            throw new IllegalArgumentException("Only run-script creation supported. Script name should be String.");
        }
        NpmRunSettings npmRunSettings = NpmRunSettings.builder().setCommand(NpmCommand.RUN_SCRIPT).setScriptNames(Collections.singletonList(scriptName)).setPackageJsonPath(configPath).build();
        if (npmRunSettings == null) {
            NpmRunConfigurationBuilder.$$$reportNull$$$0(2);
        }
        return npmRunSettings;
    }

    @Override
    protected boolean isSimilar(@NotNull NpmRunSettings s1, @NotNull NpmRunSettings s2) {
        if (s1 == null) {
            NpmRunConfigurationBuilder.$$$reportNull$$$0(3);
        }
        if (s2 == null) {
            NpmRunConfigurationBuilder.$$$reportNull$$$0(4);
        }
        return s1.getCommand().equals((Object)s2.getCommand()) && s1.getScriptNames().equals(s2.getScriptNames()) && s1.getPackageJsonSystemDependentPath().equals(s2.getPackageJsonSystemDependentPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRunSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSimilar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

