/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runConfiguration;

import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JSTestLocation;", "", "localTestFilePath", "", "testNames", "", "test", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Z)V", "getLocalTestFilePath", "()Ljava/lang/String;", "getTestNames", "()Ljava/util/List;", "toLocationUrl", "toLocationUrlWithoutFilePath", "components", "Companion", "intellij.javascript.backend"})
public final class JSTestLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String localTestFilePath;
    @NotNull
    private final List<String> testNames;
    private final boolean test;

    private JSTestLocation(String localTestFilePath, List<String> testNames, boolean test) {
        this.localTestFilePath = localTestFilePath;
        this.testNames = testNames;
        this.test = test;
    }

    @NotNull
    public final String getLocalTestFilePath() {
        return this.localTestFilePath;
    }

    @NotNull
    public final List<String> getTestNames() {
        return this.testNames;
    }

    @NotNull
    public final String toLocationUrl() {
        return this.toLocationUrl(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.localTestFilePath), (Iterable)this.testNames));
    }

    @NotNull
    public final String toLocationUrlWithoutFilePath() {
        return this.toLocationUrl(this.testNames);
    }

    private final String toLocationUrl(List<String> components) {
        String protocol = this.test ? "test" : "suite";
        return protocol + "://" + EscapeUtils.join((Collection<String>)components, '.');
    }

    @JvmStatic
    @NotNull
    public static final JSTestLocation fromTestLocationUrl(@NotNull String testLocationUrl, @Nullable NodeTargetRun targetRun) throws IllegalArgumentException {
        return Companion.fromTestLocationUrl(testLocationUrl, targetRun);
    }

    @JvmStatic
    @NotNull
    public static final JSTestLocation fromTestElementPath(@NotNull JsTestElementPath testElementPath) {
        return Companion.fromTestElementPath(testElementPath);
    }

    public /* synthetic */ JSTestLocation(String localTestFilePath, List testNames, boolean test, DefaultConstructorMarker $constructor_marker) {
        this(localTestFilePath, testNames, test);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JSTestLocation$Companion;", "", "<init>", "()V", "fromTestLocationUrl", "Lcom/intellij/javascript/testing/runConfiguration/JSTestLocation;", "testLocationUrl", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "fromTestElementPath", "testElementPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJSTestLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTestLocation.kt\ncom/intellij/javascript/testing/runConfiguration/JSTestLocation$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n13#2:55\n*S KotlinDebug\n*F\n+ 1 JSTestLocation.kt\ncom/intellij/javascript/testing/runConfiguration/JSTestLocation$Companion\n*L\n47#1:55\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSTestLocation fromTestLocationUrl(@NotNull String testLocationUrl, @Nullable NodeTargetRun targetRun) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)testLocationUrl, (String)"testLocationUrl");
            String string = VirtualFileManager.extractProtocol((String)testLocationUrl);
            if (string == null) {
                throw new IllegalArgumentException("Cannot decode " + testLocationUrl);
            }
            String protocol = string;
            if (!Intrinsics.areEqual((Object)protocol, (Object)"test") && !Intrinsics.areEqual((Object)protocol, (Object)"suite")) {
                throw new IllegalStateException("Unsupported test protocol " + protocol + ", locationHint=" + testLocationUrl);
            }
            List<String> list = EscapeUtils.split(VirtualFileManager.extractPath((String)testLocationUrl), '.');
            Intrinsics.checkNotNullExpressionValue(list, (String)"split(...)");
            List<String> components = list;
            String targetPath = (String)CollectionsKt.firstOrNull(components);
            if (targetPath == null || !OSAgnosticPathUtil.isAbsolute((String)targetPath)) {
                throw new IllegalStateException("Cannot parse path=" + targetPath + " from locationUrl=" + testLocationUrl);
            }
            Object object = targetRun;
            if (object == null || (object = ((NodeTargetRun)object).convertTargetPathToLocalPath(targetPath)) == null) {
                object = targetPath;
            }
            Object localPath = object;
            return new JSTestLocation((String)localPath, components.subList(1, components.size()), Intrinsics.areEqual((Object)protocol, (Object)"test"), null);
        }

        @JvmStatic
        @NotNull
        public final JSTestLocation fromTestElementPath(@NotNull JsTestElementPath testElementPath) {
            Intrinsics.checkNotNullParameter((Object)testElementPath, (String)"testElementPath");
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)testElementPath.getTestElement());
            if (virtualFile == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JSTestLocation.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cannot find VirtualFile for " + testElementPath);
            }
            VirtualFile virtualFile2 = virtualFile;
            String string = virtualFile2 != null ? virtualFile2.getPath() : null;
            if (string == null) {
                string = "";
            }
            String string2 = FileUtil.toSystemDependentName((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            List<String> list = testElementPath.getAllNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllNames(...)");
            return new JSTestLocation(string2, list, testElementPath.getTestName() != null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

