/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryUtil;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/FullTextSearchQuery;", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "query", "", "<init>", "(Ljava/lang/String;)V", "getQueryUrl", "from", "", "limit", "maxQueryBatchSize", "getMaxQueryBatchSize", "()I", "parseContent", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "content", "toString", "FullTextPackageListJsonReader", "intellij.javascript.backend"})
public final class FullTextSearchQuery
extends NpmRegistryService.SearchQuery {
    public FullTextSearchQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        super(query);
    }

    @Override
    @NotNull
    public String getQueryUrl(int from, int limit) {
        return "https://registry.npmjs.org/-/v1/search?&text=" + URLUtil.encodeURIComponent((String)("\"" + this.query + "\"")) + "&from=" + from + "&size=" + limit;
    }

    @Override
    public int getMaxQueryBatchSize() {
        return 250;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Closeable closeable = (Closeable)new JsonReader((Reader)new StringReader(content));
        Throwable throwable = null;
        try {
            JsonReader reader = (JsonReader)closeable;
            boolean bl = false;
            List<NodePackageBasicInfo> list = new FullTextPackageListJsonReader(reader).read();
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "'" + this.query + "' (Full Text)";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/FullTextSearchQuery$FullTextPackageListJsonReader;", "", "myReader", "Lcom/google/gson/stream/JsonReader;", "<init>", "(Lcom/google/gson/stream/JsonReader;)V", "myResult", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "read", "", "readObjects", "", "readObject", "intellij.javascript.backend"})
    private static final class FullTextPackageListJsonReader {
        @NotNull
        private final JsonReader myReader;
        @NotNull
        private final List<NodePackageBasicInfo> myResult;

        public FullTextPackageListJsonReader(@NotNull JsonReader myReader) {
            Intrinsics.checkNotNullParameter((Object)myReader, (String)"myReader");
            this.myReader = myReader;
            this.myResult = new ArrayList();
        }

        @NotNull
        public final List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return CollectionsKt.emptyList();
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (Intrinsics.areEqual((Object)name, (Object)"objects")) {
                    this.readObjects();
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            return CollectionsKt.toList((Iterable)this.myResult);
        }

        public final void readObjects() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readObject();
            }
            this.myReader.endArray();
        }

        public final void readObject() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (Intrinsics.areEqual((Object)name, (Object)"package")) {
                    UtilKt.addIfNotNull(this.myResult, (Object)NpmRegistryUtil.readPackageInfo(this.myReader));
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }
    }
}

