/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.integration.impl;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.appServers.serverInstances.RunAppServerInstanceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

final class RunAppServerInstanceManagerImpl
extends RunAppServerInstanceManager {
    private final Project myProject;

    RunAppServerInstanceManagerImpl(Project project) {
        this.myProject = project;
    }

    @Nullable
    public J2EEServerInstance findInstance(CommonModel configuration) {
        if (configuration == null) {
            return null;
        }
        String name = configuration.getName();
        ProcessHandler[] currentProcesses = ExecutionManager.getInstance((Project)this.myProject).getRunningProcesses();
        J2EEServerInstance terminated = null;
        for (ProcessHandler currentProcess : currentProcesses) {
            J2EEServerInstance serverInstance;
            if (!(currentProcess instanceof J2EEProcess) || (serverInstance = ((J2EEProcess)currentProcess).getServerInstance()) == null || !Objects.equals(serverInstance.getName(), name)) continue;
            if (currentProcess.isProcessTerminating() || currentProcess.isProcessTerminated()) {
                terminated = serverInstance;
                continue;
            }
            return serverInstance;
        }
        return terminated;
    }

    @Nullable
    public ProcessHandler findHandler(J2EEServerInstance existingInstance) {
        ProcessHandler[] currentProcesses;
        for (ProcessHandler currentProcess : currentProcesses = ExecutionManager.getInstance((Project)this.myProject).getRunningProcesses()) {
            J2EEServerInstance serverInstance;
            if (!(currentProcess instanceof J2EEProcess) || (serverInstance = ((J2EEProcess)currentProcess).getServerInstance()) != existingInstance) continue;
            return currentProcess;
        }
        return null;
    }

    public boolean debuggerIsConnected(ProcessHandler processHandler) {
        return new Checker().check(processHandler);
    }

    public boolean debuggerIsPaused(ProcessHandler processHandler) {
        return new Checker(this){

            @Override
            protected boolean doCheck(DebuggerSession session) {
                return super.doCheck(session) && session.isPaused();
            }
        }.check(processHandler);
    }

    private class Checker {
        private Checker() {
        }

        public boolean check(ProcessHandler processHandler) {
            Ref result = new Ref((Object)false);
            try {
                Runnable calculableAction = () -> {
                    if (RunAppServerInstanceManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    DebugProcess debugProcess = DebuggerManager.getInstance((Project)RunAppServerInstanceManagerImpl.this.myProject).getDebugProcess(processHandler);
                    if (debugProcess == null) {
                        return;
                    }
                    DebuggerSession session = DebuggerManagerEx.getInstanceEx((Project)RunAppServerInstanceManagerImpl.this.myProject).getSession(debugProcess);
                    if (session == null) {
                        return;
                    }
                    result.set((Object)this.doCheck(session));
                };
                ApplicationManager.getApplication().invokeAndWait(calculableAction);
            }
            catch (RuntimeException e) {
                return false;
            }
            return (Boolean)result.get();
        }

        protected boolean doCheck(DebuggerSession session) {
            return session.isAttached();
        }
    }
}

