/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/parsing/LineTerminators;", "", "<init>", "()V", "hasLineTerminatorBefore", "", "builder", "Lcom/intellij/lang/PsiBuilder;", "hasLineTerminatorAfter", "hasLineTerminator", "at", "", "intellij.javascript.parser"})
public final class LineTerminators {
    @NotNull
    public static final LineTerminators INSTANCE = new LineTerminators();

    private LineTerminators() {
    }

    public final boolean hasLineTerminatorBefore(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.OR_RBRACE) {
            return true;
        }
        return this.hasLineTerminator(builder, -1);
    }

    public final boolean hasLineTerminatorAfter(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.hasLineTerminator(builder, 1);
    }

    public final boolean hasLineTerminator(@NotNull PsiBuilder builder, int at) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        int at2 = at;
        IElementType boundElementType = builder.rawLookup(at2);
        while (boundElementType == JSTokenTypes.WHITE_SPACE || boundElementType == JSTokenTypes.HEREDOC_BOUND || JSElementTypes.COMMENTS.contains(boundElementType)) {
            int end = builder.rawTokenTypeStart(at2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)builder.getOriginalText(), (String)"getOriginalText(...)");
            for (int start = builder.rawTokenTypeStart(at2); start < end; ++start) {
                CharSequence sequence;
                char ch = sequence.charAt(start);
                switch (ch) {
                    case '\n': 
                    case '\r': 
                    case '\u2028': 
                    case '\u2029': {
                        return true;
                    }
                }
            }
            at2 = at2 < 0 ? --at2 : ++at2;
            boundElementType = builder.rawLookup(at2);
        }
        return false;
    }
}

