/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.formatter.CompositeBlock;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.SpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeJSBlock
extends CompositeBlock
implements BlockEx {
    private final IElementType myParentElementType;
    private final Language myLanguage;
    private final CommonCodeStyleSettings myCommonSettings;
    private final JSCodeStyleSettings myCustomSettings;

    public CompositeJSBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent, @NotNull IElementType parentElementType, @NotNull JSBlockContext blockContext) {
        if (childBlocks == null) {
            CompositeJSBlock.$$$reportNull$$$0(0);
        }
        if (spacingStrategy == null) {
            CompositeJSBlock.$$$reportNull$$$0(1);
        }
        if (parentElementType == null) {
            CompositeJSBlock.$$$reportNull$$$0(2);
        }
        if (blockContext == null) {
            CompositeJSBlock.$$$reportNull$$$0(3);
        }
        super(blockContext.modifySubBlocksIfNeeded(childBlocks), spacingStrategy, indent);
        this.myParentElementType = parentElementType;
        this.myLanguage = blockContext.getDialect();
        this.myCommonSettings = blockContext.getCommonSettings();
        this.myCustomSettings = blockContext.getDialectSettings();
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myParentElementType == JSElementTypes.PACKAGE_STATEMENT && this.myCustomSettings.INDENT_PACKAGE_CHILDREN == 0) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (this.myParentElementType == JSElementTypes.SWITCH_STATEMENT) {
            JSBlock previousJSBlock = JSBlock.getPreviousJSBlock(this.getSubBlocks(), newChildIndex);
            return new ChildAttributes(JSBlock.calculateIndentInSwitch(previousJSBlock, this.myCommonSettings), null);
        }
        return new ChildAttributes(Indent.getNormalIndent(), null);
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "childBlocks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "spacingStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parentElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "blockContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/formatter/blocks/CompositeJSBlock";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

