/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.CssResolveSupport;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSObjectLiteralExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerObjectType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.StylesheetFileMarker;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    protected final boolean myTypeScript;

    public TypeScriptQualifiedItemProcessor(T sink, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        super(sink, containingFile);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)this.place, (Object)containingFile));
        this.myTypeScript = holder != null && holder.isTypeScript;
    }

    public static boolean processNamespaceChildren(@NotNull ResolveProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @Nullable PsiElement place, @NotNull PsiElement element) {
        if (processor == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        boolean statics = processor.getAccessibilityProcessingHandler().isProcessStatics();
        if (element instanceof JSVariable) {
            return !statics || JSResolveUtil.processDeclarationsInScope((JSVariable)element, processor, state, lastParent, place);
        }
        if (element instanceof JSFile && processor instanceof JSModuleElementsProcessor) {
            if (statics) {
                return ES6PsiUtil.processExportDeclarationInScope(element, (JSModuleElementsProcessor)((Object)processor));
            }
            return true;
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return true;
        }
        return place == null || element.processDeclarations((PsiScopeProcessor)processor, state, lastParent, place);
    }

    @Override
    protected void handleActionScriptFunctionExpressionEvents(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(4);
        }
    }

    public void processImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        String name = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        PsiElement sourceElement = type.getSourceElement();
        if (name == null && type.isSourceStrict() && this.myTypeScript && this.isUnnamedTypeWithoutProperties(type)) {
            this.forceResolvedState(type);
            return;
        }
        if (name == null || sourceElement == null) {
            this.doProcessImpl(type, evaluateContext);
            return;
        }
        Collection<JSElement> elements = this.getElements(type, name, sourceElement);
        if (elements.isEmpty()) {
            this.doProcessImpl(type, evaluateContext);
            return;
        }
        this.processElementsForType(evaluateContext, type, elements);
        if (type.isSourceStrict() && this.myTypeScript) {
            this.forceResolvedState(type);
        }
    }

    private void forceResolvedState(@NotNull JSType type) {
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        if (!(type instanceof TypeScriptJSFunctionTypeImpl) || !TypeScriptQualifiedItemProcessor.isApplicableFuncSource(type.getSourceElement())) {
            this.resolved = QualifiedItemProcessor.TypeResolveState.Resolved;
        }
    }

    private static boolean isApplicableFuncSource(@Nullable PsiElement element) {
        if (!(element instanceof JSFunction)) {
            return false;
        }
        if (!(element instanceof JSExpression)) {
            return true;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSVariable) || ((JSVariable)parent).getInitializerOrStub() != element) {
            return false;
        }
        return ((JSVariable)parent).isConst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementsForType(@NotNull JSEvaluateContext evaluateContext, @NotNull JSType type, @NotNull Collection<? extends PsiElement> elements) {
        JSTypeSubstitutor substitutor;
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        ResolveState state = (substitutor = TypeScriptQualifiedItemProcessor.getTypeSubstitutor(type, elements)) == null ? ResolveState.initial() : ResolveState.initial().put(JSResolveResult.GENERICS, (Object)substitutor);
        Set<TypeScriptInterfaceClass> classes = elements.stream().filter(el -> el instanceof TypeScriptInterfaceClass).map(el -> (TypeScriptInterfaceClass)el).collect(Collectors.toSet());
        boolean savedProcessStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        if (type instanceof JSNamespace) {
            JSNamespace jsNamespace = (JSNamespace)type;
            this.getAccessibilityProcessingHandler().setProcessStatics(jsNamespace.getJSContext() == JSContext.STATIC);
        }
        try {
            this.processClasses(classes, state);
            HashSet<TypeScriptEnum> processedEnums = new HashSet<TypeScriptEnum>();
            for (PsiElement psiElement : elements) {
                TypeScriptEnum owner;
                if (classes.contains(psiElement)) continue;
                if (psiElement instanceof TypeScriptTypeAlias) {
                    JSType declaration = ((TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration();
                    if (declaration == null) continue;
                    JSEvaluationRecursionGuard.processWithEvaluationGuard(psiElement, evaluateContext, () -> {
                        this.process(JSTypeUtils.applyGenericArguments(declaration, substitutor), evaluateContext);
                        return null;
                    });
                    continue;
                }
                if (this.isToProcessHierarchy() && psiElement instanceof TypeScriptEnumField && (owner = ((TypeScriptEnumField)psiElement).getOwner()) != null && processedEnums.add(owner)) {
                    this.processClasses(JBIterable.of((Object[])owner.getSuperClasses()).filter(TypeScriptInterfaceClass.class).toSet(), state);
                }
                this.processWithLocalResolveForModules(psiElement, state);
            }
        }
        finally {
            this.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithLocalResolveForModules(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        boolean savedLocalResolve = this.isLocalResolve();
        try {
            if (element instanceof TypeScriptModule) {
                this.setLocalResolve(true);
            }
            TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, state, element, this.place, element);
        }
        finally {
            this.setLocalResolve(savedLocalResolve);
        }
    }

    private void processClasses(@NotNull Set<TypeScriptInterfaceClass> classes, @NotNull ResolveState state) {
        if (classes == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        boolean savedValue = this.isToProcessHierarchy();
        this.setToProcessHierarchy(false);
        boolean toProcessSupers = true;
        for (TypeScriptInterfaceClass tsClass : classes) {
            toProcessSupers &= TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, state, tsClass, this.place, tsClass);
        }
        this.setToProcessHierarchy(savedValue);
        if (!savedValue || !toProcessSupers) {
            return;
        }
        for (TypeScriptInterfaceClass tsClass : classes) {
            TypeScriptClassBase.processSupers(tsClass, this, state, tsClass, this.place);
        }
    }

    @Contract(value="null -> false")
    private boolean isUnnamedTypeWithoutProperties(@Nullable JSType type) {
        return type instanceof TypeScriptNeverType || type instanceof JSVoidType || (type instanceof JSNullType || type instanceof JSUndefinedType) && TypeScriptConfigUtil.strictNullChecks(this.place);
    }

    @NotNull
    private Collection<? extends JSElement> getElements(@NotNull JSType type, @NotNull String name, @NotNull PsiElement sourceElement) {
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        if (name == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        if (sourceElement == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        PsiElement sourceToResolve = sourceElement;
        PsiFile file = sourceElement.getContainingFile();
        if (file != null && TypeScriptLibraryProvider.checkLibraryFile(sourceElement.getProject(), file.getVirtualFile()) && this.place != null) {
            sourceToResolve = this.place;
        }
        Collection<PsiElement> resolveResultElements = this.resolveElementsByTypeWithContext(type, name, sourceToResolve);
        SmartList elements = new SmartList();
        for (PsiElement element : resolveResultElements) {
            if (!(element instanceof JSElement)) continue;
            elements.add((JSElement)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    protected @Unmodifiable @NotNull Collection<? extends PsiElement> resolveElementsByTypeWithContext(@NotNull JSType type, @NotNull String qName, @NotNull PsiElement sourceToResolve) {
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        if (qName == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(20);
        }
        if (sourceToResolve == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(21);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceToResolve);
        if (collection == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @Nullable
    public static JSTypeSubstitutor getTypeSubstitutor(@Nullable JSType type, @NotNull Collection<? extends PsiElement> elements) {
        List<JSType> arguments;
        if (elements == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(23);
        }
        if ((arguments = JSTypeUtils.getGenericTypeArguments(type)) == null) {
            return null;
        }
        JSClass candidateClass = null;
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            candidateClass = (JSClass)psiElement;
            break;
        }
        if (candidateClass instanceof TypeScriptTypeParameterListOwner) {
            return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)candidateClass), arguments);
        }
        return null;
    }

    private static boolean isFromDeclareClassOrInterface(@NotNull TypeScriptFunction function) {
        JSClass parent;
        if (function == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(24);
        }
        if ((parent = JSUtils.getMemberContainingClass(function)) instanceof TypeScriptInterface) {
            return true;
        }
        if (parent instanceof TypeScriptClass && TypeScriptPsiUtil.isAbstractElement(function)) {
            return true;
        }
        return TypeScriptPsiUtil.isAmbientDeclaration(function);
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(25);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(26);
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).hasOverloadDeclarations()) {
            boolean isDeclareOrInterface = TypeScriptQualifiedItemProcessor.isFromDeclareClassOrInterface((TypeScriptFunction)element);
            boolean isImplementation = ((TypeScriptFunction)element).isOverloadImplementation();
            if (isImplementation || isDeclareOrInterface && !((TypeScriptFunction)element).isOverloadDeclaration()) {
                boolean result = true;
                for (TypeScriptFunction function : ((TypeScriptFunction)element).getOverloadDeclarations()) {
                    result &= super.executeAcceptedElement(function, state);
                }
                if (!isImplementation) {
                    result &= super.executeAcceptedElement(element, state);
                }
                return result;
            }
        }
        if (element instanceof TypeScriptIndexSignature) {
            TypeScriptIndexSignature indexSignature = (TypeScriptIndexSignature)element;
            if (this.myName != null && JSRecordTypeImpl.isPropNameApplicableToIndexSignature(this.myName, indexSignature)) {
                return ((ResultSink)this.getResultSink()).addResult(element, state, this.getPlaceTopParent());
            }
        }
        return super.executeAcceptedElement(element, state);
    }

    @Override
    public final void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(27);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(28);
        }
        if (type instanceof JSModuleTypeImpl) {
            PsiElement module = ((JSModuleTypeImpl)type).getModule();
            ES6PsiUtil.processExportDeclarationInScope(module, this, evaluateContext, ((JSModuleTypeImpl)type).isFromRequire(), null);
            boolean hasIncompleteMatch = false;
            if (module instanceof JSFile) {
                JSModuleStatusOwner.ModuleStatus status = ((JSFile)module).getModuleStatus();
                boolean bl = hasIncompleteMatch = status == JSModuleStatusOwner.ModuleStatus.COMMONJS || status == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
            }
            if (!hasIncompleteMatch) {
                this.forceResolvedState();
            }
            return;
        }
        if (type instanceof JSObjectLiteralExpressionType) {
            JSObjectLiteralExpression element = ((JSObjectLiteralExpressionType)type).findAssociatedExpression();
            if (element != null) {
                element.processDeclarations(this, ResolveState.initial(), (PsiElement)element, this.place);
            }
            return;
        }
        if (type instanceof TypeScriptCompilerObjectType) {
            TypeScriptCompilerObjectType objectType = (TypeScriptCompilerObjectType)type;
            Collection declarations = objectType.getDeclarations();
            if (ContainerUtil.exists((Iterable)declarations, TypeScriptInterfaceClass.class::isInstance)) {
                JSType substituted = type.substitute().substitute();
                this.processElementsForType(evaluateContext, substituted, declarations);
            } else {
                JSRecordType recordType = objectType.asRecordType();
                this.processRecordTypeImpl(recordType, true);
            }
            this.forceResolvedState();
            return;
        }
        JSType substituted = type.substitute((PsiElement)evaluateContext.targetFile);
        this.processImpl(substituted, evaluateContext);
        if (this.resolved == QualifiedItemProcessor.TypeResolveState.Unknown) {
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                if (!handler.useOnlyCompleteMatch(type, evaluateContext)) continue;
                this.forceResolvedState();
                break;
            }
        }
    }

    protected void doProcessImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        Object element;
        JSGenericParameterImpl genericParameter;
        JSType constraintType;
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(30);
        }
        if (type instanceof JSGenericParameterImpl && (constraintType = (genericParameter = (JSGenericParameterImpl)type).getConstraintType()) != null) {
            type = constraintType;
        }
        if (type instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)type;
            this.processRecordTypeImpl(recordType, false);
            return;
        }
        if (type instanceof JSClassExpressionType) {
            JSClassExpressionType classExpressionType = (JSClassExpressionType)type;
            boolean isStatic = classExpressionType.getJSContext() == JSContext.STATIC;
            JSClassExpression element2 = classExpressionType.findAssociatedExpression();
            if (element2 != null) {
                AccessibilityProcessingHandler.processWithStatic(this, isStatic, () -> element2.processDeclarations(this, ResolveState.initial(), element2, this.place));
                if (this.myTypeScript && type.isSourceStrict() && !this.isTypeContext() && this.resolved != QualifiedItemProcessor.TypeResolveState.PrefixUnknown) {
                    this.forceResolvedState();
                }
            }
            return;
        }
        if ((type instanceof JsonElementType || type instanceof JSCustomElementType) && !TypeScriptQualifiedItemProcessor.processResolvedElement(element = ((JSTypeOfPsiElementBase)type).getElement(), this)) {
            this.forceResolvedState();
        }
        JSType finalType = type;
        JSEvaluationRecursionGuard.evaluateWithGuard(type, evaluateContext, () -> JSTypeUtils.processExpandedType(this, finalType, evaluateContext));
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type, boolean isFromTypeScriptCompilerType) {
        JSRecordType.IndexSignature indexer;
        List<PsiElement> results;
        String name;
        if (type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(31);
        }
        if (this.myTypeScript && type.isSourceStrict() && this.resolved != QualifiedItemProcessor.TypeResolveState.PrefixUnknown) {
            this.forceResolvedState();
        }
        if (type instanceof JSNotARecordType) {
            return;
        }
        PsiElement sourceElement = type.getSourceElement();
        if (sourceElement == null && ApplicationManager.getApplication().isUnitTestMode() && this.place != null && !((TypeScriptCompilerEvaluationFacade)this.place.getProject().getService(TypeScriptCompilerEvaluationFacade.class)).isAnyEnabled()) {
            Logger.getInstance(this.getClass()).error((Throwable)((Object)new AssertionError((Object)"Record type source must be not empty")));
        }
        boolean isSimpleRecordWithDefinedSource = type instanceof JSSimpleRecordTypeImpl && sourceElement != null && sourceElement.isValid();
        boolean isTypeScriptObjectType = sourceElement instanceof TypeScriptObjectType;
        if (isSimpleRecordWithDefinedSource && (sourceElement instanceof JSClassExpression || isTypeScriptObjectType)) {
            Stream<JSType> constructors = JSTypeUtils.getFunctionType(type, true, this.place);
            this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
            boolean found = !sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place);
            boolean processBaseDeclarations = !found || isTypeScriptObjectType && TypeScriptQualifiedItemProcessor.hasOnlyIndexers(this.getResults());
            boolean processObjectClassMembers = this.getResultSink() instanceof ResolveResultSink;
            if (processBaseDeclarations && isTypeScriptObjectType && processObjectClassMembers) {
                boolean hasCallSignature = false;
                boolean hasConstructSignature = false;
                for (TypeScriptTypeMember typeMember : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    hasCallSignature |= typeMember instanceof JSRecordType.CallSignature && !((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                    hasConstructSignature |= typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                }
                this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
            }
            return;
        }
        if (isSimpleRecordWithDefinedSource && sourceElement instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteralExpression = (JSObjectLiteralExpression)sourceElement;
            for (JSProperty property : objectLiteralExpression.getProperties()) {
                if (this.execute((PsiElement)property, ResolveState.initial())) continue;
                return;
            }
        }
        boolean isCompleteResolve = isSimpleRecordWithDefinedSource || !(this.getResultSink() instanceof ResolveResultSink) || sourceElement != null && (DialectDetector.isTypeScript(sourceElement) || type.isSourceStrict());
        for (JSRecordType.TypeMember typeMember : type.getProperties()) {
            String name2 = this.getName();
            if (name2 != null && !name2.equals(typeMember.getMemberName())) continue;
            if (!type.isSourceStrict()) {
                typeMember = typeMember.copyTypeHierarchy(t -> t.copyWithStrict(false));
            }
            if (this.processRecordTypeMember(sourceElement, !isSimpleRecordWithDefinedSource, isCompleteResolve, typeMember, isFromTypeScriptCompilerType)) continue;
            return;
        }
        PsiElement location = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation();
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement) && !ES6PsiUtil.isExternalModule(sourceElement) || location != null && isFromTypeScriptCompilerType) {
            boolean hasCallSignature = false;
            boolean hasConstructSignature = false;
            List<JSRecordType.CallSignature> signatures = type.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures) {
                hasCallSignature |= !signature.hasNew();
                hasConstructSignature |= signature.hasNew();
            }
            this.processSuperClassMembers(location != null ? location : sourceElement, hasCallSignature, hasConstructSignature);
        }
        if ((name = this.getName()) != null && type.hasIndexers() && ((results = this.getResults()) == null || results.isEmpty()) && (indexer = type.findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null && !indexer.isForComputedProperty()) {
            PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)indexer.getMemberSource().getSingleElement(), (Object)sourceElement);
            if (element == null) {
                return;
            }
            this.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), element, false), ResolveState.initial());
        }
    }

    private static boolean processResolvedElement(@NotNull PsiElement element, @NotNull JSResolveProcessor processor) {
        if (element == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(33);
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                JsonFile file = (JsonFile)element;
                value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> file.getTopLevelValue());
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                        return false;
                    }
                } else {
                    List list = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
            }
        } else if (element instanceof StylesheetFileMarker) {
            CssResolveSupport.getInstance().processCssClasses((StylesheetFileMarker)element, processor);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasOnlyIndexers(List<PsiElement> results) {
        if (results == null) return false;
        if (!ContainerUtil.and(results, TypeScriptIndexSignature.class::isInstance)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean processRecordTypeMember(@Nullable PsiElement sourceElement, boolean createImplicitElements, boolean isCompleteResolve, @NotNull JSRecordType.TypeMember typeMember, boolean isFromTypeScriptCompilerType) {
        if (typeMember == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(34);
        }
        elementsByTypeMember = isFromTypeScriptCompilerType != false ? typeMember.getMemberSource().getAllSourceElements() : TypeScriptQualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, createImplicitElements);
        elements = elementsByTypeMember.isEmpty() != false && isFromTypeScriptCompilerType != false ? TypeScriptQualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, true) : elementsByTypeMember;
        added = false;
        if (!(typeMember instanceof JSRecordType.PropertySignature) || !((var11_10 = (propertySignature = (JSRecordType.PropertySignature)typeMember).getJSType()) instanceof TypeScriptCompilerType)) ** GOTO lbl-1000
        tsCompilerType = (TypeScriptCompilerType)var11_10;
        if (!this.isSimple(sourceElement) && !elements.isEmpty()) {
            builder = new JSImplicitElementImpl.Builder(propertySignature.getMemberName(), null).setType(JSImplicitElement.Type.Property);
            implicitElement = new JSImplicitElementImpl(builder){

                @Override
                public JSType getJSType(@Nullable PsiElement evaluationLocation) {
                    return tsCompilerType;
                }

                @Override
                public PsiElement getParent() {
                    return ((PsiElement)elements.iterator().next()).getContainingFile();
                }
            };
            if (!this.execute((PsiElement)implicitElement, ResolveState.initial())) {
                added = true;
            }
        } else lbl-1000:
        // 7 sources

        {
            for (PsiElement element : elements) {
                if (element == null) continue;
                if (!isCompleteResolve) {
                    this.addPossibleCandidateResult(element, null);
                    continue;
                }
                if (element instanceof JSImplicitElement && !(element instanceof TypeScriptProxyImplicitElement)) {
                    this.addResult(element);
                    continue;
                }
                if (this.execute(element, ResolveState.initial())) continue;
                added = true;
            }
        }
        return added == false;
    }

    private boolean isSimple(@Nullable PsiElement element) {
        return element == null || element instanceof JSLiteralExpression || element instanceof JSObjectLiteralExpression || element instanceof JSArrayLiteralExpression || element instanceof JSClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature, boolean hasConstructSignature) {
        if (sourceElement == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(35);
        }
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        this.handleEvent(INHERITED_CLASSES_STARTED, 20);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature || hasConstructSignature ? JSTypeUtils.getFunctionTypeName(sourceElement.getContainingFile(), hasConstructSignature) : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, (PsiElement)object);
            }
        }
        finally {
            this.handleEvent(INHERITED_CLASSES_FINISHED, 20);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 11: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 19: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceToResolve";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByTypeWithContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleActionScriptFunctionExpressionEvents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceResolvedState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processElementsForType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processWithLocalResolveForModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 18: 
            case 22: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsByTypeWithContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFromDeclareClassOrInterface";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doProcessImpl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeMember";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 22 -> new IllegalStateException(string);
        };
    }
}

