/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme;

import com.intellij.css.scheme.CssValueTokenTypes;
import com.intellij.css.scheme.psi.AllExprImpl;
import com.intellij.css.scheme.psi.AndExprImpl;
import com.intellij.css.scheme.psi.AnyExprImpl;
import com.intellij.css.scheme.psi.FuncCallImpl;
import com.intellij.css.scheme.psi.InlineImpl;
import com.intellij.css.scheme.psi.NamedValueImpl;
import com.intellij.css.scheme.psi.OrExprImpl;
import com.intellij.css.scheme.psi.ParenExprImpl;
import com.intellij.css.scheme.psi.PropertyReferenceImpl;
import com.intellij.css.scheme.psi.QuantifierImpl;
import com.intellij.css.scheme.psi.SimpleExprImpl;
import com.intellij.css.scheme.psi.TextValueImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface CssValueTypes {
    public static final IElementType ALL_EXPR = new CssValueTokenTypes.CssValueTokenType("ALL_EXPR");
    public static final IElementType AND_EXPR = new CssValueTokenTypes.CssValueTokenType("AND_EXPR");
    public static final IElementType ANY_EXPR = new CssValueTokenTypes.CssValueTokenType("ANY_EXPR");
    public static final IElementType EXPRESSION = new CssValueTokenTypes.CssValueTokenType("EXPRESSION");
    public static final IElementType FUNC_CALL = new CssValueTokenTypes.CssValueTokenType("FUNC_CALL");
    public static final IElementType INLINE = new CssValueTokenTypes.CssValueTokenType("INLINE");
    public static final IElementType NAMED_VALUE = new CssValueTokenTypes.CssValueTokenType("NAMED_VALUE");
    public static final IElementType OR_EXPR = new CssValueTokenTypes.CssValueTokenType("OR_EXPR");
    public static final IElementType PAREN_EXPR = new CssValueTokenTypes.CssValueTokenType("PAREN_EXPR");
    public static final IElementType PROPERTY_REFERENCE = new CssValueTokenTypes.CssValueTokenType("PROPERTY_REFERENCE");
    public static final IElementType QUANTIFIER = new CssValueTokenTypes.CssValueTokenType("QUANTIFIER");
    public static final IElementType SIMPLE_EXPR = new CssValueTokenTypes.CssValueTokenType("SIMPLE_EXPR");
    public static final IElementType TEXT_VALUE = new CssValueTokenTypes.CssValueTokenType("TEXT_VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ALL_EXPR) {
                return new AllExprImpl(node);
            }
            if (type == AND_EXPR) {
                return new AndExprImpl(node);
            }
            if (type == ANY_EXPR) {
                return new AnyExprImpl(node);
            }
            if (type == FUNC_CALL) {
                return new FuncCallImpl(node);
            }
            if (type == INLINE) {
                return new InlineImpl(node);
            }
            if (type == NAMED_VALUE) {
                return new NamedValueImpl(node);
            }
            if (type == OR_EXPR) {
                return new OrExprImpl(node);
            }
            if (type == PAREN_EXPR) {
                return new ParenExprImpl(node);
            }
            if (type == PROPERTY_REFERENCE) {
                return new PropertyReferenceImpl(node);
            }
            if (type == QUANTIFIER) {
                return new QuantifierImpl(node);
            }
            if (type == SIMPLE_EXPR) {
                return new SimpleExprImpl(node);
            }
            if (type == TEXT_VALUE) {
                return new TextValueImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

