/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.util.JSCommonRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.trivialif.JSSplitIfAndIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSplitIfOrIntention
extends JSIntention {
    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.split-if-or.display-name", new Object[0]);
        if (string == null) {
            JSSplitIfOrIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.split-if-or.family-name", new Object[0]);
        if (string == null) {
            JSSplitIfOrIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SplitIfOrPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement jsElement;
        if (project == null) {
            JSSplitIfOrIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSplitIfOrIntention.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = jsElement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        assert (jsElement != null);
        assert (jsElement instanceof JSIfStatement);
        JSIfStatement ifStatement = (JSIfStatement)jsElement;
        assert (ifStatement.getCondition() instanceof JSBinaryExpression);
        JSBinaryExpression condition = (JSBinaryExpression)ifStatement.getCondition();
        String lhsText = JSSplitIfAndIntention.getConditionText(condition.getLOperand(), condition);
        String rhsText = JSSplitIfAndIntention.getConditionText(condition.getROperand(), condition);
        JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
        JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
        String thenText = thenBranch.getText();
        assert (condition.getOperationSign().equals(JSTokenTypes.OROR));
        StringBuilder statement = new StringBuilder(ifStatement.getTextLength());
        statement.append("if (").append(lhsText).append(')').append(thenText).append("\nelse if (").append(rhsText).append(')').append(thenText);
        if (elseBranch != null) {
            statement.append(" else ").append(elseBranch.getText());
        }
        JSCommonRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)statement.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfOrIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfOrIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class SplitIfOrPredicate
    implements JSElementPredicate {
        private SplitIfOrPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            JSExpression condition;
            PsiElement parent;
            if (element == null) {
                SplitIfOrPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((condition = (ifStatement = (JSIfStatement)parent).getCondition()) == null || PsiUtilCore.hasErrorElementChild((PsiElement)condition)) {
                return false;
            }
            return condition instanceof JSBinaryExpression && JSTokenTypes.OROR.equals(((JSBinaryExpression)condition).getOperationSign());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfOrIntention$SplitIfOrPredicate", "satisfiedBy"));
        }
    }
}

