/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.prettierjs.PrettierPostFormatProcessorKt;
import com.intellij.prettierjs.ReformatWithPrettierAction;
import com.intellij.prettierjs.formatting.PrettierRangeKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/prettierjs/PrettierPostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "processElement", "Lcom/intellij/psi/PsiElement;", "source", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processText", "Lcom/intellij/openapi/util/TextRange;", "psiFile", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "intellij.prettierJS"})
public final class PrettierPostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile psiFile, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (Registry.Companion.get("prettier.use.async.formatting.service").asBoolean()) {
            return rangeToReformat;
        }
        if (PrettierPostFormatProcessorKt.isApplicable(psiFile)) {
            TextRange extendedRange = PrettierRangeKt.extendRange(psiFile, rangeToReformat);
            TextRange textRange = ReformatWithPrettierAction.processFileAsPostFormatProcessor(psiFile, extendedRange);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"processFileAsPostFormatProcessor(...)");
            return textRange;
        }
        return rangeToReformat;
    }
}

