/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DatabaseBoundaryValueResolver implements BoundaryValueResolver
{
    DATE((Class)Date.class, Dbms::isPostgres, "infinity", "-infinity", new String[]{"date", "daterange"}){

        @NotNull
        public Object createJdbcPositiveInfinityValue() {
            Date date = Infinity.PG_POSITIVE_INFINITY_DATE;
            if (date == null) {
                1.$$$reportNull$$$0(0);
            }
            return date;
        }

        @NotNull
        public Object createJdbcNegativeInfinityValue() {
            Date date = Infinity.PG_NEGATIVE_INFINITY_DATE;
            if (date == null) {
                1.$$$reportNull$$$0(1);
            }
            return date;
        }

        public boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                1.$$$reportNull$$$0(2);
            }
            return object instanceof java.util.Date && ((java.util.Date)object).getTime() >= Infinity.PG_DATE_MIN_POSITIVE_INFINITY_TIME;
        }

        public boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                1.$$$reportNull$$$0(3);
            }
            return object instanceof java.util.Date && ((java.util.Date)object).getTime() <= Infinity.PG_DATE_MAX_NEGATIVE_INFINITY_TIME;
        }

        @NotNull
        public Date getPresentablePositiveInfinity() {
            Date date = Date.valueOf(Infinity.PG_POSITIVE_INF_DATE);
            if (date == null) {
                1.$$$reportNull$$$0(4);
            }
            return date;
        }

        @NotNull
        public Date getPresentableNegativeInfinity() {
            Date date = Date.valueOf(Infinity.PG_NEGATIVE_INF_DATE);
            if (date == null) {
                1.$$$reportNull$$$0(5);
            }
            return date;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
    ,
    TIMESTAMP((Class)Timestamp.class, Dbms::isPostgres, "infinity", "-infinity", new String[]{"timestamp", "tsrange"}){

        @NotNull
        public Object createJdbcPositiveInfinityValue() {
            Timestamp timestamp = Infinity.PG_POSITIVE_INFINITY_TIMESTAMP;
            if (timestamp == null) {
                2.$$$reportNull$$$0(0);
            }
            return timestamp;
        }

        @NotNull
        public Object createJdbcNegativeInfinityValue() {
            Timestamp timestamp = Infinity.PG_NEGATIVE_INFINITY_TIMESTAMP;
            if (timestamp == null) {
                2.$$$reportNull$$$0(1);
            }
            return timestamp;
        }

        public boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                2.$$$reportNull$$$0(2);
            }
            return object instanceof Timestamp && ((Timestamp)object).getTime() >= Infinity.PG_TIMESTAMP_MIN_POSITIVE_INFINITY_TIME;
        }

        public boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                2.$$$reportNull$$$0(3);
            }
            return object instanceof Timestamp && ((Timestamp)object).getTime() <= Infinity.PG_TIMESTAMP_MAX_NEGATIVE_INFINITY_TIME;
        }

        @NotNull
        public java.util.Date getPresentablePositiveInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_POSITIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                2.$$$reportNull$$$0(4);
            }
            return timestamp;
        }

        @NotNull
        public java.util.Date getPresentableNegativeInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_NEGATIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                2.$$$reportNull$$$0(5);
            }
            return timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
    ,
    TIMESTAMP_TZ((Class)TimeZonedTimestamp.class, Dbms::isPostgres, "infinity", "-infinity", new String[]{"timestamptz", "tstzrange"}){

        @NotNull
        public Object createJdbcNegativeInfinityValue() {
            TimeZonedTimestamp timeZonedTimestamp = Infinity.PG_NEGATIVE_INFINITY_TIMESTAMP_TZ;
            if (timeZonedTimestamp == null) {
                3.$$$reportNull$$$0(0);
            }
            return timeZonedTimestamp;
        }

        @NotNull
        public Object createJdbcPositiveInfinityValue() {
            TimeZonedTimestamp timeZonedTimestamp = Infinity.PG_POSITIVE_INFINITY_TIMESTAMP_TZ;
            if (timeZonedTimestamp == null) {
                3.$$$reportNull$$$0(1);
            }
            return timeZonedTimestamp;
        }

        public boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                3.$$$reportNull$$$0(2);
            }
            return object instanceof TimeZonedTimestamp && 3.toLocalDateTime((TimeZonedTimestamp)object).isAfter(Infinity.PG_MAX_TIMESTAMP);
        }

        public boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                3.$$$reportNull$$$0(3);
            }
            return object instanceof TimeZonedTimestamp && 3.toLocalDateTime((TimeZonedTimestamp)object).isBefore(Infinity.PG_MIN_TIMESTAMP);
        }

        @NotNull
        private static LocalDateTime toLocalDateTime(@NotNull TimeZonedTimestamp object) {
            if (object == null) {
                3.$$$reportNull$$$0(4);
            }
            LocalDateTime localDateTime = ((OffsetDateTime)object.getValue()).withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
            if (localDateTime == null) {
                3.$$$reportNull$$$0(5);
            }
            return localDateTime;
        }

        @NotNull
        public java.util.Date getPresentablePositiveInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_POSITIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                3.$$$reportNull$$$0(6);
            }
            return timestamp;
        }

        @NotNull
        public java.util.Date getPresentableNegativeInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_NEGATIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                3.$$$reportNull$$$0(7);
            }
            return timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$3";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$3";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toLocalDateTime";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "toLocalDateTime";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    };

    private final String[] myTypeNames;
    private final Class<?> myObjectClass;
    private final Condition<Dbms> myFamilyChecker;
    private final String myPositiveInfinityString;
    private final String myNegativeInfinityString;

    private DatabaseBoundaryValueResolver(@Nullable Class<?> objectClass, @Nullable Condition<Dbms> familyChecker, @NotNull String positiveInfinityString, String negativeInfinityString, String ... typeNames) {
        if (typeNames == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(0);
        }
        this.myObjectClass = objectClass;
        this.myFamilyChecker = DatabaseBoundaryValueResolver.notNull(familyChecker);
        this.myTypeNames = typeNames;
        this.myPositiveInfinityString = positiveInfinityString;
        this.myNegativeInfinityString = negativeInfinityString;
    }

    @Nullable
    public String getPositiveInfinityString() {
        return this.myPositiveInfinityString;
    }

    @Nullable
    public String getNegativeInfinityString() {
        return this.myNegativeInfinityString;
    }

    @Nullable
    public Class<?> getObjectClass() {
        return this.myObjectClass;
    }

    @NotNull
    public static BoundaryValueResolver getResolver(@Nullable Dbms family, @Nullable GridColumn column) {
        for (DatabaseBoundaryValueResolver resolver : DatabaseBoundaryValueResolver.values()) {
            boolean columnTypeEquals = StringUtil.findIgnoreCase((String)(column == null ? null : column.getTypeName()), (String[])resolver.myTypeNames);
            if (!resolver.myFamilyChecker.value((Object)family) || !columnTypeEquals) continue;
            DatabaseBoundaryValueResolver databaseBoundaryValueResolver = resolver;
            if (databaseBoundaryValueResolver == null) {
                DatabaseBoundaryValueResolver.$$$reportNull$$$0(1);
            }
            return databaseBoundaryValueResolver;
        }
        BoundaryValueResolver boundaryValueResolver = ALWAYS_NULL;
        if (boundaryValueResolver == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(2);
        }
        return boundaryValueResolver;
    }

    @Nullable
    public static String getInfinityString(@Nullable Dbms family, @Nullable GridColumn column, @NotNull Object object) {
        if (object == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(3);
        }
        return DatabaseBoundaryValueResolver.getResolver(family, column).getInfinityString(object);
    }

    @NotNull
    private static Condition<Dbms> notNull(@Nullable Condition<Dbms> condition) {
        Condition condition2 = condition == null ? Conditions.alwaysFalse() : id -> id != null && condition.value(id);
        if (condition2 == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(4);
        }
        return condition2;
    }

    @NotNull
    public java.util.Date getLegacyDate(@NotNull Object object) {
        if (object == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(5);
        }
        java.util.Date date = (java.util.Date)Rules.MAP.get(object.getClass()).fun(object);
        if (date == null) {
            DatabaseBoundaryValueResolver.$$$reportNull$$$0(6);
        }
        return date;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInfinityString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyDate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }

    static final class Infinity {
        static final String PG_POSITIVE_INFINITY = "infinity";
        static final String PG_NEGATIVE_INFINITY = "-infinity";
        static final LocalDateTime PG_MAX_TIMESTAMP = LocalDateTime.of(294276, 12, 31, 23, 59, 59, 999999999);
        static final LocalDateTime PG_MIN_TIMESTAMP = LocalDateTime.of(4713, 1, 1, 0, 0, 0, 0).with(ChronoField.ERA, 0L);
        static final LocalDateTime PG_POSITIVE_INF_TIMESTAMP = PG_MAX_TIMESTAMP.plusNanos(1L);
        static final LocalDateTime PG_NEGATIVE_INF_TIMESTAMP = PG_MIN_TIMESTAMP.minusNanos(1L);
        static final LocalDate PG_MAX_DATE = LocalDate.of(5874897, 12, 31);
        static final LocalDate PG_MIN_DATE = LocalDate.of(4713, 1, 1).with(ChronoField.ERA, 0L);
        static final LocalDate PG_POSITIVE_INF_DATE = PG_MAX_DATE.plusDays(1L);
        static final LocalDate PG_NEGATIVE_INF_DATE = PG_MIN_DATE.minusDays(1L);
        static final long PG_POSITIVE_INFINITY_TIME = 9223372036825200000L;
        static final long PG_NEGATIVE_INFINITY_TIME = -9223372036832400000L;
        static final long PG_TIMESTAMP_MIN_POSITIVE_INFINITY_TIME = Timestamp.valueOf(PG_POSITIVE_INF_TIMESTAMP).getTime();
        static final long PG_TIMESTAMP_MAX_NEGATIVE_INFINITY_TIME = Timestamp.valueOf(PG_NEGATIVE_INF_TIMESTAMP).getTime();
        static final long PG_DATE_MIN_POSITIVE_INFINITY_TIME = Date.valueOf(PG_POSITIVE_INF_DATE).getTime();
        static final long PG_DATE_MAX_NEGATIVE_INFINITY_TIME = Date.valueOf(PG_NEGATIVE_INF_DATE).getTime();
        static final Timestamp PG_POSITIVE_INFINITY_TIMESTAMP = new Timestamp(9223372036825200000L);
        static final Timestamp PG_NEGATIVE_INFINITY_TIMESTAMP = new Timestamp(-9223372036832400000L);
        static final Date PG_POSITIVE_INFINITY_DATE = new Date(9223372036825200000L);
        static final Date PG_NEGATIVE_INFINITY_DATE = new Date(-9223372036832400000L);
        static final TimeZonedTimestamp PG_POSITIVE_INFINITY_TIMESTAMP_TZ = new TimeZonedTimestamp(PG_POSITIVE_INF_TIMESTAMP.atOffset(ZoneOffset.UTC)){

            @Override
            @NotNull
            public JdbcInjection injection(@NotNull Dbms family, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
                if (family == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (formatsCache == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (formatterCreator == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new JdbcInjection.DefaultTimestampInjection(Infinity.PG_POSITIVE_INFINITY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "family";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "formatsCache";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "formatterCreator";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$Infinity$1";
                objectArray[2] = "injection";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        static final TimeZonedTimestamp PG_NEGATIVE_INFINITY_TIMESTAMP_TZ = new TimeZonedTimestamp(PG_NEGATIVE_INF_TIMESTAMP.atOffset(ZoneOffset.UTC)){

            @Override
            @NotNull
            public JdbcInjection injection(@NotNull Dbms family, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
                if (family == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (formatsCache == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (formatterCreator == null) {
                    2.$$$reportNull$$$0(2);
                }
                return new JdbcInjection.DefaultTimestampInjection(Infinity.PG_NEGATIVE_INFINITY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "family";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "formatsCache";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "formatterCreator";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/grid/editors/DatabaseBoundaryValueResolver$Infinity$2";
                objectArray[2] = "injection";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        Infinity() {
        }
    }

    static final class Rules {
        static final Map<Class<?>, Function<Object, java.util.Date>> MAP = Map.of(java.util.Date.class, o -> (java.util.Date)o, Date.class, o -> (java.util.Date)o, Timestamp.class, o -> (java.util.Date)o, TimeZonedTimestamp.class, o -> Timestamp.valueOf(((OffsetDateTime)((TimeZonedTimestamp)o).getValue()).toLocalDateTime()));

        Rules() {
        }
    }
}

