/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.color;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.color.ColorSpace;
import com.intellij.psi.css.impl.util.color.CssColor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0001H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u001f\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001f\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010$\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0017\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u0017\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"INVALID", "", "isInvalid", "", "getCssColorInRGBsFunctions", "Lcom/intellij/psi/css/impl/util/color/CssColor;", "termList", "Lcom/intellij/psi/css/CssTermList;", "text", "", "getCssColorInHSLsFunctions", "getCssColorInHwbFunction", "getCssColorInLabFunction", "okVersion", "getCssColorInLchFunction", "getAlphaFromTerms", "(Lcom/intellij/psi/css/CssTermList;)Ljava/lang/Double;", "terms", "", "(Ljava/util/List;)Ljava/lang/Double;", "getHue", "term", "Lcom/intellij/psi/css/CssTerm;", "(Lcom/intellij/psi/css/CssTerm;)Ljava/lang/Double;", "getHueTemporary", "(Ljava/lang/String;)Ljava/lang/Double;", "normalizeAngle", "value", "maxValue", "getRatio", "(Lcom/intellij/psi/css/CssTerm;D)Ljava/lang/Double;", "(Ljava/lang/String;D)Ljava/lang/Double;", "getUnboundRatio", "hundredPercentIs", "getUnboundRatioTemporary", "getAngle", "getAngleTemporary", "getAlpha", "getAlphaTemporary", "getStringTerms", "intellij.css.psi"})
@SourceDebugExtension(value={"SMAP\nColorResolveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorResolveUtil.kt\ncom/intellij/psi/css/impl/util/color/ColorResolveUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,519:1\n158#2,6:520\n158#2,6:526\n*S KotlinDebug\n*F\n+ 1 ColorResolveUtil.kt\ncom/intellij/psi/css/impl/util/color/ColorResolveUtilKt\n*L\n431#1:520,6\n453#1:526,6\n*E\n"})
public final class ColorResolveUtilKt {
    private static final double INVALID = Double.NaN;

    private static final boolean isInvalid(double $this$isInvalid) {
        return Double.isNaN($this$isInvalid);
    }

    @Nullable
    public static final CssColor getCssColorInRGBsFunctions(@NotNull CssTermList termList) {
        Double alpha;
        Double blue;
        Double green;
        Double red;
        Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
        CssTerm[] cssTermArray = termList.getTerms();
        Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
        CssTerm[] terms = cssTermArray;
        if (terms.length == 0) {
            String string = termList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return ColorResolveUtilKt.getCssColorInRGBsFunctions(string);
        }
        int n = terms.length;
        if (!(3 <= n ? n < 5 : false)) {
            return null;
        }
        CssTerm cssTerm = terms[0];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        Double d = red = ColorResolveUtilKt.getRatio(cssTerm, 255.0);
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        CssTerm cssTerm2 = terms[1];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm2, (String)"get(...)");
        Double d2 = green = ColorResolveUtilKt.getRatio(cssTerm2, 255.0);
        boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
        if (bl2) {
            return null;
        }
        CssTerm cssTerm3 = terms[2];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm3, (String)"get(...)");
        Double d3 = blue = ColorResolveUtilKt.getRatio(cssTerm3, 255.0);
        boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
        if (bl3) {
            return null;
        }
        Double d4 = alpha = ColorResolveUtilKt.getAlphaFromTerms(termList);
        boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
        if (bl4) {
            return null;
        }
        Double[] doubleArray = new Double[]{red, green, blue, alpha};
        return new CssColor(ColorSpace.SRGB, doubleArray);
    }

    @Nullable
    public static final CssColor getCssColorInRGBsFunctions(@NotNull String text) {
        Double alpha;
        Double blue;
        Double green;
        Double red;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<String> list = ColorResolveUtilKt.getStringTerms(text);
        if (list == null) {
            return null;
        }
        List<String> terms = list;
        Double d = red = ColorResolveUtilKt.getRatio(terms.get(0), 255.0);
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        Double d2 = green = ColorResolveUtilKt.getRatio(terms.get(1), 255.0);
        boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
        if (bl2) {
            return null;
        }
        Double d3 = blue = ColorResolveUtilKt.getRatio(terms.get(2), 255.0);
        boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
        if (bl3) {
            return null;
        }
        Double d4 = alpha = ColorResolveUtilKt.getAlphaFromTerms(terms);
        boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
        if (bl4) {
            return null;
        }
        Double[] doubleArray = new Double[]{red, green, blue, alpha};
        return new CssColor(ColorSpace.SRGB, doubleArray);
    }

    @Nullable
    public static final CssColor getCssColorInHSLsFunctions(@NotNull CssTermList termList) {
        Double alpha;
        Double lightness;
        Double saturation;
        Double hue;
        Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
        CssTerm[] cssTermArray = termList.getTerms();
        Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
        CssTerm[] terms = cssTermArray;
        if (terms.length == 0) {
            Double alpha2;
            Double lightness2;
            Double saturation2;
            Double hue2;
            String string = termList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List<String> list = ColorResolveUtilKt.getStringTerms(string);
            if (list == null) {
                return null;
            }
            List<String> terms2 = list;
            String string2 = termList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            boolean isLegacy = StringsKt.contains$default((CharSequence)string2, (CharSequence)",", (boolean)false, (int)2, null);
            if (!(!isLegacy || StringsKt.contains$default((CharSequence)terms2.get(1), (char)'%', (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)terms2.get(2), (char)'%', (boolean)false, (int)2, null))) {
                return null;
            }
            Double d = hue2 = ColorResolveUtilKt.getHueTemporary(terms2.get(0));
            boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
            if (bl) {
                return null;
            }
            Double d2 = saturation2 = ColorResolveUtilKt.getRatio(terms2.get(1), 100.0);
            boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
            if (bl2) {
                return null;
            }
            Double d3 = lightness2 = ColorResolveUtilKt.getRatio(terms2.get(2), 100.0);
            boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
            if (bl3) {
                return null;
            }
            Double d4 = alpha2 = ColorResolveUtilKt.getAlphaFromTerms(terms2);
            boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
            if (bl4) {
                return null;
            }
            Double[] doubleArray = new Double[]{hue2, saturation2, lightness2, alpha2};
            return new CssColor(ColorSpace.HSL, doubleArray);
        }
        int terms2 = terms.length;
        if (!(3 <= terms2 ? terms2 < 5 : false)) {
            return null;
        }
        String string = termList.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        boolean isLegacy = StringsKt.contains$default((CharSequence)string, (CharSequence)",", (boolean)false, (int)2, null);
        if (!(!isLegacy || Intrinsics.areEqual((Object)termList.getTerms()[1].getTermType(), (Object)CssTermTypes.PERCENTAGE) && Intrinsics.areEqual((Object)termList.getTerms()[2].getTermType(), (Object)CssTermTypes.PERCENTAGE))) {
            return null;
        }
        CssTerm cssTerm = terms[0];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        Double d = hue = ColorResolveUtilKt.getHue(cssTerm);
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        CssTerm cssTerm2 = terms[1];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm2, (String)"get(...)");
        Double d5 = saturation = ColorResolveUtilKt.getRatio(cssTerm2, 100.0);
        boolean bl5 = d5 != null ? ColorResolveUtilKt.isInvalid(d5) : false;
        if (bl5) {
            return null;
        }
        CssTerm cssTerm3 = terms[2];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm3, (String)"get(...)");
        Double d6 = lightness = ColorResolveUtilKt.getRatio(cssTerm3, 100.0);
        boolean bl6 = d6 != null ? ColorResolveUtilKt.isInvalid(d6) : false;
        if (bl6) {
            return null;
        }
        Double d7 = alpha = ColorResolveUtilKt.getAlphaFromTerms(termList);
        boolean bl7 = d7 != null ? ColorResolveUtilKt.isInvalid(d7) : false;
        if (bl7) {
            return null;
        }
        Double[] doubleArray = new Double[]{hue, saturation, lightness, alpha};
        return new CssColor(ColorSpace.HSL, doubleArray);
    }

    @Nullable
    public static final CssColor getCssColorInHwbFunction(@NotNull CssTermList termList) {
        Double alpha;
        Double blackness;
        Double whiteness;
        Double hue;
        Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
        CssTerm[] cssTermArray = termList.getTerms();
        Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
        CssTerm[] terms = cssTermArray;
        if (terms.length == 0) {
            Double alpha2;
            Double blackness2;
            Double whiteness2;
            Double hue2;
            String string = termList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List<String> list = ColorResolveUtilKt.getStringTerms(string);
            if (list == null) {
                return null;
            }
            List<String> terms2 = list;
            Double d = hue2 = ColorResolveUtilKt.getHueTemporary(terms2.get(0));
            boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
            if (bl) {
                return null;
            }
            Double d2 = whiteness2 = ColorResolveUtilKt.getRatio(terms2.get(1), 100.0);
            boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
            if (bl2) {
                return null;
            }
            Double d3 = blackness2 = ColorResolveUtilKt.getRatio(terms2.get(2), 100.0);
            boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
            if (bl3) {
                return null;
            }
            Double d4 = alpha2 = ColorResolveUtilKt.getAlphaFromTerms(terms2);
            boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
            if (bl4) {
                return null;
            }
            Double[] doubleArray = new Double[]{hue2, whiteness2, blackness2, alpha2};
            return new CssColor(ColorSpace.HWB, doubleArray);
        }
        int terms2 = terms.length;
        if (!(3 <= terms2 ? terms2 < 5 : false)) {
            return null;
        }
        CssTerm cssTerm = terms[0];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        Double d = hue = ColorResolveUtilKt.getHue(cssTerm);
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        CssTerm cssTerm2 = terms[1];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm2, (String)"get(...)");
        Double d5 = whiteness = ColorResolveUtilKt.getRatio(cssTerm2, 100.0);
        boolean bl5 = d5 != null ? ColorResolveUtilKt.isInvalid(d5) : false;
        if (bl5) {
            return null;
        }
        CssTerm cssTerm3 = terms[2];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm3, (String)"get(...)");
        Double d6 = blackness = ColorResolveUtilKt.getRatio(cssTerm3, 100.0);
        boolean bl6 = d6 != null ? ColorResolveUtilKt.isInvalid(d6) : false;
        if (bl6) {
            return null;
        }
        Double d7 = alpha = ColorResolveUtilKt.getAlphaFromTerms(termList);
        boolean bl7 = d7 != null ? ColorResolveUtilKt.isInvalid(d7) : false;
        if (bl7) {
            return null;
        }
        Double[] doubleArray = new Double[]{hue, whiteness, blackness, alpha};
        return new CssColor(ColorSpace.HWB, doubleArray);
    }

    @Nullable
    public static final CssColor getCssColorInLabFunction(@NotNull CssTermList termList, boolean okVersion) {
        Double alpha;
        Double opponentB;
        Double opponentA;
        Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
        CssTerm[] cssTermArray = termList.getTerms();
        Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
        CssTerm[] terms = cssTermArray;
        if (terms.length == 0) {
            Double alpha2;
            Double opponentB2;
            Double opponentA2;
            String string = termList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List<String> list = ColorResolveUtilKt.getStringTerms(string);
            if (list == null) {
                return null;
            }
            List<String> terms2 = list;
            double maxLightness = okVersion ? 1.0 : 100.0;
            Double lightness = ColorResolveUtilKt.getRatio(terms2.get(0), maxLightness);
            if (lightness != null && okVersion) {
                lightness = lightness / (double)100;
            }
            Double d = lightness;
            boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
            if (bl) {
                return null;
            }
            double maxValue = okVersion ? 0.4 : 125.0;
            Double d2 = opponentA2 = ColorResolveUtilKt.getUnboundRatioTemporary(terms2.get(1), maxValue);
            boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
            if (bl2) {
                return null;
            }
            Double d3 = opponentB2 = ColorResolveUtilKt.getUnboundRatioTemporary(terms2.get(2), maxValue);
            boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
            if (bl3) {
                return null;
            }
            Double d4 = alpha2 = ColorResolveUtilKt.getAlphaFromTerms(terms2);
            boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
            if (bl4) {
                return null;
            }
            ColorSpace colorSpaceId = okVersion ? ColorSpace.OKLAB : ColorSpace.LAB;
            Double[] doubleArray = new Double[]{lightness, opponentA2, opponentB2, alpha2};
            return new CssColor(colorSpaceId, doubleArray);
        }
        int terms2 = terms.length;
        if (!(3 <= terms2 ? terms2 < 5 : false)) {
            return null;
        }
        double maxLightness = okVersion ? 1.0 : 100.0;
        CssTerm cssTerm = terms[0];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        Double lightness = ColorResolveUtilKt.getRatio(cssTerm, maxLightness);
        if (lightness != null && okVersion) {
            lightness = lightness / (double)100;
        }
        Double d = lightness;
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        double maxValue = okVersion ? 0.4 : 125.0;
        CssTerm cssTerm2 = terms[1];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm2, (String)"get(...)");
        Double d5 = opponentA = ColorResolveUtilKt.getUnboundRatio(cssTerm2, maxValue);
        boolean bl5 = d5 != null ? ColorResolveUtilKt.isInvalid(d5) : false;
        if (bl5) {
            return null;
        }
        CssTerm cssTerm3 = terms[2];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm3, (String)"get(...)");
        Double d6 = opponentB = ColorResolveUtilKt.getUnboundRatio(cssTerm3, maxValue);
        boolean bl6 = d6 != null ? ColorResolveUtilKt.isInvalid(d6) : false;
        if (bl6) {
            return null;
        }
        Double d7 = alpha = ColorResolveUtilKt.getAlphaFromTerms(termList);
        boolean bl7 = d7 != null ? ColorResolveUtilKt.isInvalid(d7) : false;
        if (bl7) {
            return null;
        }
        ColorSpace colorSpaceId = okVersion ? ColorSpace.OKLAB : ColorSpace.LAB;
        Double[] doubleArray = new Double[]{lightness, opponentA, opponentB, alpha};
        return new CssColor(colorSpaceId, doubleArray);
    }

    @Nullable
    public static final CssColor getCssColorInLchFunction(@NotNull CssTermList termList, boolean okVersion) {
        Double alpha;
        Double hue;
        Double chroma;
        Double lightness;
        CssTerm[] terms;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
                CssTerm[] cssTermArray = termList.getTerms();
                Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
                terms = cssTermArray;
                if (terms.length == 0) {
                    Double alpha2;
                    Double hue2;
                    Double chroma2;
                    Double lightness2;
                    String string = termList.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    List<String> list = ColorResolveUtilKt.getStringTerms(string);
                    if (list == null) {
                        return null;
                    }
                    List<String> terms2 = list;
                    double maxLightness = okVersion ? 1.0 : 100.0;
                    Double d = lightness2 = ColorResolveUtilKt.getRatio(terms2.get(0), maxLightness);
                    boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
                    if (bl) {
                        return null;
                    }
                    if (lightness2 != null && okVersion) {
                        lightness2 = lightness2 / (double)100;
                    }
                    double maxChroma = okVersion ? 0.4 : 150.0;
                    Double d2 = chroma2 = ColorResolveUtilKt.getUnboundRatioTemporary(terms2.get(1), maxChroma);
                    boolean bl2 = d2 != null ? ColorResolveUtilKt.isInvalid(d2) : false;
                    if (bl2) {
                        return null;
                    }
                    if (chroma2 != null && chroma2 < 0.0) {
                        chroma2 = 0.0;
                    }
                    Double d3 = hue2 = ColorResolveUtilKt.getHueTemporary(terms2.get(2));
                    boolean bl3 = d3 != null ? ColorResolveUtilKt.isInvalid(d3) : false;
                    if (bl3) {
                        return null;
                    }
                    Double d4 = alpha2 = ColorResolveUtilKt.getAlphaFromTerms(terms2);
                    boolean bl4 = d4 != null ? ColorResolveUtilKt.isInvalid(d4) : false;
                    if (bl4) {
                        return null;
                    }
                    ColorSpace colorSpaceId = okVersion ? ColorSpace.OKLCH : ColorSpace.LCH;
                    Double[] doubleArray = new Double[]{lightness2, chroma2, hue2, alpha2};
                    return new CssColor(colorSpaceId, doubleArray);
                }
                int terms2 = terms.length;
                boolean bl = 3 <= terms2 ? terms2 < 5 : false;
                if (!bl) break block17;
                String string = termList.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)",", (boolean)false, (int)2, null)) break block18;
            }
            return null;
        }
        double maxLightness = okVersion ? 1.0 : 100.0;
        CssTerm cssTerm = terms[0];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        Double d = lightness = ColorResolveUtilKt.getRatio(cssTerm, maxLightness);
        boolean bl = d != null ? ColorResolveUtilKt.isInvalid(d) : false;
        if (bl) {
            return null;
        }
        if (lightness != null && okVersion) {
            lightness = lightness / (double)100;
        }
        double maxChroma = okVersion ? 0.4 : 150.0;
        CssTerm cssTerm2 = terms[1];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm2, (String)"get(...)");
        Double d5 = chroma = ColorResolveUtilKt.getUnboundRatio(cssTerm2, maxChroma);
        boolean bl5 = d5 != null ? ColorResolveUtilKt.isInvalid(d5) : false;
        if (bl5) {
            return null;
        }
        if (chroma != null && chroma < 0.0) {
            chroma = 0.0;
        }
        CssTerm cssTerm3 = terms[2];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm3, (String)"get(...)");
        Double d6 = hue = ColorResolveUtilKt.getHue(cssTerm3);
        boolean bl6 = d6 != null ? ColorResolveUtilKt.isInvalid(d6) : false;
        if (bl6) {
            return null;
        }
        Double d7 = alpha = ColorResolveUtilKt.getAlphaFromTerms(termList);
        boolean bl7 = d7 != null ? ColorResolveUtilKt.isInvalid(d7) : false;
        if (bl7) {
            return null;
        }
        ColorSpace colorSpaceId = okVersion ? ColorSpace.OKLCH : ColorSpace.LCH;
        Double[] doubleArray = new Double[]{lightness, chroma, hue, alpha};
        return new CssColor(colorSpaceId, doubleArray);
    }

    private static final Double getAlphaFromTerms(CssTermList termList) {
        Double d;
        if (termList.getTerms().length == 3) {
            d = 1.0;
        } else {
            CssTerm cssTerm = termList.getTerms()[3];
            Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
            d = ColorResolveUtilKt.getAlpha(cssTerm);
        }
        return d;
    }

    private static final Double getAlphaFromTerms(List<String> terms) {
        return terms.size() == 3 ? Double.valueOf(1.0) : ColorResolveUtilKt.getAlphaTemporary(terms.get(3));
    }

    private static final Double getHue(CssTerm term) {
        Double d;
        String string = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"none")) {
            return null;
        }
        CssTermType cssTermType = term.getTermType();
        if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NUMBER) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_NUMBER)) {
            String string2 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Double d2 = StringsKt.toDoubleOrNull((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
            if (d2 == null) {
                return Double.NaN;
            }
            double value = d2;
            d = ColorResolveUtilKt.normalizeAngle(value, 360.0);
        } else {
            d = Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.ANGLE) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_ANGLE) ? Double.valueOf(ColorResolveUtilKt.getAngle(term)) : Double.valueOf(Double.NaN);
        }
        return d;
    }

    private static final Double getHueTemporary(String text) {
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)text)).toString(), (Object)"none")) {
            return null;
        }
        return ColorResolveUtilKt.getAngleTemporary(text);
    }

    private static final double normalizeAngle(double value, double maxValue) {
        return (value % maxValue + maxValue) % maxValue / maxValue;
    }

    private static final Double getRatio(CssTerm term, double maxValue) {
        Double d;
        String string = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"none")) {
            return null;
        }
        CssTermType cssTermType = term.getTermType();
        if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.PERCENTAGE) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_PERCENTAGE)) {
            String string2 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)string2, (String)"%", (String)"", (boolean)false, (int)4, null));
            if (d2 == null) {
                return Double.NaN;
            }
            double value = d2;
            d = Math.clamp(value, 0.0, 100.0) / 100.0;
        } else if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NUMBER) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_NUMBER)) {
            String string3 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Double d3 = StringsKt.toDoubleOrNull((String)string3);
            if (d3 == null) {
                return Double.NaN;
            }
            double value = d3;
            d = Math.clamp(value, 0.0, maxValue) / maxValue;
        } else {
            d = Double.NaN;
        }
        return d;
    }

    private static final Double getRatio(String text, double maxValue) {
        if (Intrinsics.areEqual((Object)text, (Object)"none")) {
            return null;
        }
        int ndx = StringsKt.indexOf$default((CharSequence)text, (char)'%', (int)0, (boolean)false, (int)6, null);
        if (ndx < 0) {
            Double d = StringsKt.toDoubleOrNull((String)text);
            if (d == null) {
                return Double.NaN;
            }
            double value = d;
            return Math.clamp(value, 0.0, maxValue) / maxValue;
        }
        Double d = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)text, (String)"%", (String)"", (boolean)false, (int)4, null));
        if (d == null) {
            return Double.NaN;
        }
        double value = d;
        return Math.clamp(value, 0.0, 100.0) / 100.0;
    }

    private static final Double getUnboundRatio(CssTerm term, double hundredPercentIs) {
        Double d;
        String string = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"none")) {
            return null;
        }
        CssTermType cssTermType = term.getTermType();
        if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.PERCENTAGE) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_PERCENTAGE)) {
            String string2 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)string2, (String)"%", (String)"", (boolean)false, (int)4, null));
            if (d2 == null) {
                return Double.NaN;
            }
            double value = d2;
            d = value / 100.0 * hundredPercentIs / 100.0;
        } else if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NUMBER) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_NUMBER)) {
            String string3 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Double d3 = StringsKt.toDoubleOrNull((String)string3);
            if (d3 == null) {
                return Double.NaN;
            }
            double value = d3;
            d = value / 100.0;
        } else {
            d = Double.NaN;
        }
        return d;
    }

    private static final Double getUnboundRatioTemporary(String text, double hundredPercentIs) {
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)text)).toString(), (Object)"none")) {
            return null;
        }
        int ndx = StringsKt.indexOf$default((CharSequence)text, (char)'%', (int)0, (boolean)false, (int)6, null);
        if (ndx < 0) {
            Double d = StringsKt.toDoubleOrNull((String)text);
            if (d == null) {
                return Double.NaN;
            }
            double value = d;
            return value / 100.0;
        }
        Double d = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)text, (String)"%", (String)"", (boolean)false, (int)4, null));
        if (d == null) {
            return Double.NaN;
        }
        double value = d;
        return value / 100.0 * hundredPercentIs / 100.0;
    }

    private static final double getAngle(CssTerm term) {
        double d;
        String unit;
        int firstLetterIndex;
        block19: {
            int n;
            String string = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$indexOfFirst$iv = string;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!Character.isLetter(it)) continue;
                n = index$iv;
                break block19;
            }
            n = firstLetterIndex = -1;
        }
        if (firstLetterIndex == -1) {
            return Double.NaN;
        }
        String string = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 0;
        String string3 = string2.substring(n, firstLetterIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        Double d2 = StringsKt.toDoubleOrNull((String)string3);
        if (d2 == null) {
            return Double.NaN;
        }
        double value = d2;
        String string4 = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String string5 = string4.substring(firstLetterIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        switch (unit = string5) {
            case "deg": {
                d = 360.0;
                break;
            }
            case "rad": {
                d = Math.PI * 2;
                break;
            }
            case "grad": {
                d = 400.0;
                break;
            }
            case "turn": {
                d = 1.0;
                break;
            }
            default: {
                return Double.NaN;
            }
        }
        double maxValue = d;
        return ColorResolveUtilKt.normalizeAngle(value, maxValue);
    }

    private static final double getAngleTemporary(String text) {
        double d;
        String unit;
        int firstLetterIndex;
        block20: {
            int n;
            CharSequence $this$indexOfFirst$iv = text;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!Character.isLetter(it)) continue;
                n = index$iv;
                break block20;
            }
            n = firstLetterIndex = -1;
        }
        if (firstLetterIndex == -1) {
            Double d2 = StringsKt.toDoubleOrNull((String)text);
            if (d2 == null) {
                return Double.NaN;
            }
            double value = d2;
            return ColorResolveUtilKt.normalizeAngle(value, 360.0);
        }
        String string = text.substring(0, firstLetterIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Double d3 = StringsKt.toDoubleOrNull((String)string);
        if (d3 == null) {
            return Double.NaN;
        }
        double value = d3;
        String string2 = text.substring(firstLetterIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        switch (unit = string2) {
            case "deg": {
                d = 360.0;
                break;
            }
            case "rad": {
                d = Math.PI * 2;
                break;
            }
            case "grad": {
                d = 400.0;
                break;
            }
            case "turn": {
                d = 1.0;
                break;
            }
            default: {
                return Double.NaN;
            }
        }
        double maxValue = d;
        return ColorResolveUtilKt.normalizeAngle(value, maxValue);
    }

    private static final Double getAlpha(CssTerm term) {
        Double d;
        String string = term.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"none")) {
            return null;
        }
        CssTermType cssTermType = term.getTermType();
        if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.PERCENTAGE) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_PERCENTAGE)) {
            String string2 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)string2, (String)"%", (String)"", (boolean)false, (int)4, null));
            if (d2 == null) {
                return Double.NaN;
            }
            double value = d2;
            d = Math.clamp(value / 100.0, 0.0, 1.0);
        } else if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NUMBER) || Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.NEGATIVE_NUMBER)) {
            String string3 = term.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Double d3 = StringsKt.toDoubleOrNull((String)string3);
            if (d3 == null) {
                return Double.NaN;
            }
            double value = d3;
            d = Math.clamp(value, 0.0, 1.0);
        } else {
            return Double.NaN;
        }
        return d;
    }

    private static final Double getAlphaTemporary(String text) {
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)text)).toString(), (Object)"none")) {
            return null;
        }
        int ndx = StringsKt.indexOf$default((CharSequence)text, (char)'%', (int)0, (boolean)false, (int)6, null);
        if (ndx < 0) {
            Double d = StringsKt.toDoubleOrNull((String)text);
            if (d == null) {
                return Double.NaN;
            }
            double value = d;
            return Math.clamp(value, 0.0, 1.0);
        }
        Double d = StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)text, (String)"%", (String)"", (boolean)false, (int)4, null));
        if (d == null) {
            return Double.NaN;
        }
        double value = d;
        return Math.clamp(value / 100.0, 0.0, 1.0);
    }

    private static final List<String> getStringTerms(String text) {
        Object[] objectArray = new String[]{",", "/"};
        List list = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new String[]{" ", " "};
        String string = StringUtil.replace((String)text, (List)list, (List)CollectionsKt.mutableListOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        String spaceSeparated = string;
        List list2 = StringUtil.split((String)spaceSeparated, (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(...)");
        List terms = list2;
        if (terms.size() != 3 && terms.size() != 4) {
            return null;
        }
        return terms;
    }
}

