/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.debug;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfileDuringDebugOptions;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorStateObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "enable", "", "getEnable", "()Z", "profileDuringDebugOptions", "Lcom/intellij/profiler/ProfileDuringDebugOptions;", "getProfileDuringDebugOptions", "()Lcom/intellij/profiler/ProfileDuringDebugOptions;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "notifyProfilingStartsNextSession", "stateObserver", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorStateObserver;", "getOngoingDebuggerSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.profiler.ultimate"})
public abstract class ProfileOnRunToCursorAction
extends DumbAwareAction {
    public abstract boolean getEnable();

    @NotNull
    protected final ProfileDuringDebugOptions getProfileDuringDebugOptions() {
        return ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getProfileDuringDebugOptions();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setVisible(this.getProfileDuringDebugOptions().getEnableRunToCursor() != this.getEnable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.getProfileDuringDebugOptions().setEnableRunToCursor(this.getEnable());
        ProfileOnRunToCursorStateObserver stateObserver = ProfileOnRunToCursorStateObserver.Companion.getInstance();
        if (this.getEnable()) {
            ProfilerUsageTriggerCollector.INSTANCE.logProfileDuringRunToCursor(e.getProject());
            if (!this.notifyProfilingStartsNextSession(e, stateObserver)) {
                stateObserver.enableRecording();
            }
        } else {
            ProfilerUsageTriggerCollector.INSTANCE.logDisableProfilingDuringRunToCursor(e.getProject());
            stateObserver.disableRecording();
        }
    }

    private final boolean notifyProfilingStartsNextSession(AnActionEvent e, ProfileOnRunToCursorStateObserver stateObserver) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        DebuggerSession debuggerSession = this.getOngoingDebuggerSession(project2);
        if (debuggerSession == null || (debuggerSession = debuggerSession.getProcess()) == null) {
            return false;
        }
        DebuggerSession ongoingDebugProcess = debuggerSession;
        if (!stateObserver.hasActiveProcess((DebugProcess)ongoingDebugProcess)) {
            ProfilerManager.INSTANCE.showStickyInfo(UltimateProfilerBundleKt.profilerMessage("action.profiler.profileOnRunToCursor.activated.message", new Object[0]), project2);
            return true;
        }
        return false;
    }

    private final DebuggerSession getOngoingDebuggerSession(Project $this$getOngoingDebuggerSession) {
        DebuggerManager debuggerManager = DebuggerManager.getInstance((Project)$this$getOngoingDebuggerSession);
        DebuggerManagerEx debuggerManagerEx = debuggerManager instanceof DebuggerManagerEx ? (DebuggerManagerEx)debuggerManager : null;
        if (debuggerManagerEx == null) {
            return null;
        }
        DebuggerManagerEx manager = debuggerManagerEx;
        return manager.getContext().getDebuggerSession();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

