/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renametag;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBBox;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class RenameTagDialog
extends BaseRefactoringDialog {
    private final JLabel tagNameLabel = new JLabel();
    private final JTextField newTagField;
    private final XmlTag tag;

    RenameTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        String tagName = tag.getName();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.rename.tag", new Object[0]));
        this.tagNameLabel.setText(RefactorXBundle.message("label.text.new.name.for.tag.0", tagName));
        this.newTagField = new JTextField("");
        Document document = this.newTagField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.RenameTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.newTagField;
    }

    public String getNewTagName() {
        return this.newTagField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.change.name.of.tag.0", tagName));
        panel.add((Component)this.tagNameLabel, "North");
        JBBox box = JBBox.createVerticalBox();
        panel.setBorder(border);
        this.newTagField.setEditable(true);
        box.add((Component)this.newTagField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getNewTagName();
        boolean tagNameEntered = XMLRefactoringUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String newTagName = this.getNewTagName();
        return " <xsl:template match=\"" + tagName + "\">\n/t<xsl:tag name=\"" + newTagName + "\">\n/t/t<xsl:value-of select=\".\" />\n/t</xsl:tag>\n </xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.renameTag";
    }
}

