/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.rename.inplace;

import com.intellij.database.Dbms;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (!editor2.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        return SqlInplaceRenameHandler.isRenameable(element);
    }

    @Nullable
    public static SqlNameElement getNameElement(@Nullable PsiElement element) {
        SqlNameElement nameElement;
        if (element instanceof SqlFileImpl.FakeDefinition) {
            return null;
        }
        SqlNameElement sqlNameElement = nameElement = element instanceof SqlDefinition ? ((SqlDefinition)element).getNameElement() : null;
        if (nameElement == null && element instanceof SqlReferenceExpression && element instanceof PsiNameIdentifierOwner) {
            nameElement = ((SqlReferenceExpression)element).getIdentifier();
        }
        return nameElement;
    }

    public static boolean isRenameable(@Nullable PsiElement element) {
        return SqlInplaceRenameHandler.getNameElement(element) != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor2) {
        PsiElement identifier;
        if (element == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        if (elementToRename == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if ((identifier = elementToRename.getNameIdentifier()) != null) {
            return new MyMemberInplaceRenamer(elementToRename, element, editor2);
        }
        MemberInplaceRenamer memberInplaceRenamer = super.createMemberRenamer(element, elementToRename, editor2);
        if (memberInplaceRenamer == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        return memberInplaceRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMemberRenamer";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class MyMemberInplaceRenamer
    extends MemberInplaceRenamer {
        private String myForcedPrefix;
        private final SqlLanguageDialectEx myRealLang;

        MyMemberInplaceRenamer(@NotNull PsiNameIdentifierOwner elementToRename, PsiElement substituted, Editor editor2) {
            if (elementToRename == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)elementToRename, substituted, editor2);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix((PsiNamedElement)elementToRename);
            this.myRealLang = SqlImplUtil.getSqlDialectSafe((PsiElement)elementToRename);
        }

        private MyMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor2, String initialName, String oldName) {
            if (elementToRename == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(1);
            }
            super(elementToRename, substituted, editor2, initialName, oldName);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix(elementToRename);
            this.myRealLang = SqlImplUtil.getSqlDialectSafe((PsiElement)elementToRename);
        }

        @Nullable
        private static String getForcedPrefix(@NotNull PsiNamedElement element) {
            Dbms id;
            if (element == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(2);
            }
            if (!(id = SqlImplUtil.getSqlDialectSafe((PsiElement)element).getDbms()).isTransactSql()) {
                return null;
            }
            if (element instanceof SqlVariableDefinition) {
                return "@";
            }
            return null;
        }

        protected boolean isIdentifier(String newName, Language l) {
            if (StringUtil.isEmpty((String)newName)) {
                return false;
            }
            if (!this.checkPrefix(newName)) {
                return false;
            }
            SqlReferenceElementType refElementType = SqlCompositeElementTypes.SQL_SHORT_REFERENCE;
            String realNewName = this.myRealLang.quoteIdentifier(this.myProject, newName, refElementType.getTargetKind());
            SqlReferenceExpression ref2 = SqlPsiElementFactory.createReferenceFromText((String)realNewName, (SqlLanguageDialect)this.myRealLang, (SqlReferenceElementType)refElementType, (PsiElement)this.myScope);
            return ref2 != null && ref2.getIdentifier() != null;
        }

        private boolean checkPrefix(@NotNull String name2) {
            if (name2 == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(3);
            }
            return this.myForcedPrefix == null || name2.startsWith(this.myForcedPrefix);
        }

        protected PsiElement getNameIdentifier() {
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            PsiFile psiFile = currentFile = currentFile == null ? null : SqlImplUtil.getTopLevelSqlFile((PsiFile)currentFile);
            if (currentFile == null || !PsiTreeUtil.isContextAncestor((PsiElement)currentFile, (PsiElement)this.myElementToRename, (boolean)false)) {
                return super.getNameIdentifier();
            }
            return this.myElementToRename instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)this.myElementToRename).getNameIdentifier() : null;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiReference reference) {
            if (reference == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(4);
            }
            PsiElement refElement = reference.getElement();
            SqlIdentifier identifier = null;
            if (refElement instanceof SqlReferenceExpression) {
                identifier = ((SqlReferenceExpression)refElement).getIdentifier();
            } else if (refElement instanceof SqlDefinition) {
                identifier = (SqlIdentifier)ObjectUtils.tryCast((Object)((SqlDefinition)refElement).getNameElement(), SqlIdentifier.class);
            }
            if (identifier != null) {
                TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                if (textRange == null) {
                    MyMemberInplaceRenamer.$$$reportNull$$$0(5);
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(reference);
            if (textRange == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiElement element) {
            if (element == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(7);
            }
            if (element instanceof SqlReferenceExpression) {
                SqlIdentifier identifier = ((SqlReferenceExpression)element).getIdentifier();
                if (identifier != null) {
                    TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                    if (textRange == null) {
                        MyMemberInplaceRenamer.$$$reportNull$$$0(8);
                    }
                    return textRange;
                }
            } else if (element instanceof SqlIdentifier) {
                TextRange textRange = ((SqlIdentifier)element).getNameRange();
                if (textRange == null) {
                    MyMemberInplaceRenamer.$$$reportNull$$$0(9);
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(element);
            if (textRange == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(10);
            }
            return textRange;
        }

        protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
            return CollectionsKt.mapTo((Iterable)super.collectRefs(referencesSearchScope), new ArrayList(), r -> {
                PsiReference psiReference;
                SqlNameElement nameElement;
                PsiElement e = r.getElement();
                if (e instanceof SqlDefinition) {
                    SqlDefinition def = (SqlDefinition)e;
                    v0 = def.getNameElement();
                } else {
                    v0 = nameElement = null;
                }
                if (nameElement instanceof SqlIdentifier) {
                    SqlIdentifier id = (SqlIdentifier)nameElement;
                    psiReference = SqlImplUtil.getImmediateReference((SqlIdentifier)id);
                } else {
                    psiReference = r;
                }
                return psiReference;
            });
        }

        protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor2, String initialName) {
            return new MyMemberInplaceRenamer(variable, this.getSubstituted(), editor2, initialName, this.myOldName);
        }

        protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
            if (this.myInsertedName != null && !this.checkPrefix(this.myInsertedName)) {
                final PsiNamedElement variable = this.getVariable();
                if (variable != null) {
                    int offset = variable.getTextOffset();
                    this.restoreCaretOffset(offset);
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        return;
                    }
                    String cont = "Continue editing";
                    String cancel = "Cancel";
                    String ignore = "Rename anyway";
                    BaseListPopupStep<String> step2 = new BaseListPopupStep<String>(SqlBundle.message((String)"popup.title.identifier.should.start.with", (Object[])new Object[]{this.myForcedPrefix}), new String[]{"Continue editing", "Cancel", "Rename anyway"}){

                        public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                            if (selectedValue.equals("Rename anyway")) {
                                myForcedPrefix = null;
                            }
                            if (selectedValue.equals("Continue editing")) {
                                this.createInplaceRenamerToRestart(variable, myEditor, myInsertedName).performInplaceRefactoring(myNameSuggestions);
                            } else {
                                this.performRefactoringRename(myInsertedName, myMarkAction);
                            }
                            return FINAL_CHOICE;
                        }

                        public boolean isMnemonicsNavigationEnabled() {
                            return true;
                        }
                    };
                    step2.setDefaultOptionIndex(0);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).showInBestPositionFor(this.myEditor);
                }
                return;
            }
            super.performOnInvalidIdentifier(newName, nameSuggestions);
        }

        protected boolean acceptReference(PsiReference reference) {
            String referenceText;
            PsiElement element = reference.getElement();
            if (element instanceof SqlReferenceExpression) {
                referenceText = ((SqlReferenceExpression)element).getName();
            } else if (element instanceof SqlIdentifier) {
                referenceText = ((SqlIdentifier)element).getName();
            } else {
                TextRange textRange = reference.getRangeInElement();
                referenceText = textRange.substring(element.getText());
            }
            return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName(), (boolean)false);
        }

        protected SearchScope getReferencesSearchScope(VirtualFile file) {
            PsiElement scope2 = SqlImplUtil.getResolveScope((PsiFile)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument()));
            return scope2 != null ? new LocalSearchScope(scope2) : super.getReferencesSearchScope(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToRename";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeToRename";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getForcedPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkPrefix";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeToRename";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

