/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.remoteInterpreter.PySshProjectSynchronizerHelpers;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsHolder;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.DownloadAction;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyDeploymentUtil {
    private static final Logger LOG = Logger.getInstance(PyDeploymentUtil.class);

    private PyDeploymentUtil() {
    }

    static boolean isDeploymentExist(@NotNull Project project, @NotNull PyRemoteSdkAdditionalData additionalData) {
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(0);
        }
        if (additionalData == null) {
            PyDeploymentUtil.$$$reportNull$$$0(1);
        }
        String basePath = project.getProjectFilePath();
        assert (basePath != null) : "Path can't be null";
        for (PathMappingProvider provider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)additionalData)) {
            PathMappingSettings settings = provider.getPathMappingSettings(project, (RemoteSdkAdditionalData)additionalData);
            for (PathMappingSettings.PathMapping pathMapping : settings.getPathMappings()) {
                if (!pathMapping.canReplaceLocal(basePath)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    static List<PathMappingSettings.PathMapping> getPythonPathMappingsForServer(@NotNull Project project, @NotNull String serverId) {
        RemoteMappingsManager.Mappings mappingHolder;
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(2);
        }
        if (serverId == null) {
            PyDeploymentUtil.$$$reportNull$$$0(3);
        }
        return (mappingHolder = RemoteMappingsManager.getInstance((Project)project).getForServer("python", serverId)) == null ? null : mappingHolder.getSettings();
    }

    @NotNull
    static Deployable createDeployableUsingCredentials(@NotNull RemoteCredentials currentCredentialsTyped, @NotNull String serverId, @NotNull String serverName) {
        if (currentCredentialsTyped == null) {
            PyDeploymentUtil.$$$reportNull$$$0(4);
        }
        if (serverId == null) {
            PyDeploymentUtil.$$$reportNull$$$0(5);
        }
        if (serverName == null) {
            PyDeploymentUtil.$$$reportNull$$$0(6);
        }
        RemoteCredentialsHolder credentials = new RemoteCredentialsHolder(currentCredentialsTyped);
        CredentialsDeployable deployable = new CredentialsDeployable((RemoteCredentials)credentials);
        deployable.setId(serverId);
        deployable.setName(serverName);
        deployable.setIsProjectLevel(true);
        CredentialsDeployable credentialsDeployable = deployable;
        if (credentialsDeployable == null) {
            PyDeploymentUtil.$$$reportNull$$$0(7);
        }
        return credentialsDeployable;
    }

    @NotNull
    static WebServerConfig createWebConfig(@NotNull RemoteCredentials currentCredentialsTyped, @NotNull String serverId, @NotNull String serverName) {
        if (currentCredentialsTyped == null) {
            PyDeploymentUtil.$$$reportNull$$$0(8);
        }
        if (serverId == null) {
            PyDeploymentUtil.$$$reportNull$$$0(9);
        }
        if (serverName == null) {
            PyDeploymentUtil.$$$reportNull$$$0(10);
        }
        RemoteCredentialsHolder credentials = new RemoteCredentialsHolder(currentCredentialsTyped);
        WebServerConfig serverConfig = new WebServerConfig(serverId);
        serverConfig.setName(serverName);
        serverConfig.setIsProjectLevel(true);
        RemoteSdkUtil.createFromRemoteCredentials((WebServerConfig)serverConfig, (RemoteCredentials)credentials);
        WebServerConfig webServerConfig = serverConfig;
        if (webServerConfig == null) {
            PyDeploymentUtil.$$$reportNull$$$0(11);
        }
        return webServerConfig;
    }

    static void configureDeploymentForProject(@NotNull Project project, @NotNull WebServerConfig serverConfig, @NotNull PathMappingSettings.PathMapping pathMappingForDeployment, @NotNull String deployPath) {
        String serverId;
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(12);
        }
        if (serverConfig == null) {
            PyDeploymentUtil.$$$reportNull$$$0(13);
        }
        if (pathMappingForDeployment == null) {
            PyDeploymentUtil.$$$reportNull$$$0(14);
        }
        if (deployPath == null) {
            PyDeploymentUtil.$$$reportNull$$$0(15);
        }
        if ((serverId = serverConfig.getId()) == null) {
            LOG.debug("Unable to setup deployment for project " + String.valueOf(project) + ": web server config id is null");
            return;
        }
        DeploymentPathMapping mapping = new DeploymentPathMapping();
        mapping.setDeployPath(deployPath);
        mapping.setLocalPath(pathMappingForDeployment.getLocalRoot());
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        publishConfig.setPathMappings(serverId, List.of(mapping));
        publishConfig.setDefaultGroupOrServerName(serverConfig.getName());
        publishConfig.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        publishConfig.setAutoUploadExternalChanges(true);
        ((DeploymentConfigChangeListener)project.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
        RemoteMappingsManager mappingsManager = RemoteMappingsManager.getInstance((Project)project);
        RemoteMappingsManager.Mappings existingMappings = mappingsManager.getForServer("python", serverId);
        if (existingMappings != null) {
            existingMappings.setSettings(ContainerUtil.filter((Collection)existingMappings.getSettings(), o -> !o.equals((Object)pathMappingForDeployment)));
        }
    }

    @NotNull
    static PathMappingSettings.PathMapping configurePythonPathMapping(@NotNull Project project, @NotNull String serverId, @NotNull String remotePath) {
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(16);
        }
        if (serverId == null) {
            PyDeploymentUtil.$$$reportNull$$$0(17);
        }
        if (remotePath == null) {
            PyDeploymentUtil.$$$reportNull$$$0(18);
        }
        RemoteMappingsManager.Mappings mappings = new RemoteMappingsManager.Mappings();
        mappings.setServerId("python", serverId);
        String projectBasePath = project.getBasePath();
        assert (projectBasePath != null) : "Not default proj shall have path";
        PathMappingSettings.PathMapping pathMapping = new PathMappingSettings.PathMapping(projectBasePath, remotePath);
        mappings.setSettings(List.of(pathMapping));
        RemoteMappingsManager.getInstance((Project)project).setForServer(mappings);
        PathMappingSettings.PathMapping pathMapping2 = pathMapping;
        if (pathMapping2 == null) {
            PyDeploymentUtil.$$$reportNull$$$0(19);
        }
        return pathMapping2;
    }

    static void uploadProjectFilesToDefaultServer(@NotNull Project project, @NotNull VirtualFile baseDir, String @NotNull [] fileNames, @NotNull Consumer<? super Boolean> callback) {
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(20);
        }
        if (baseDir == null) {
            PyDeploymentUtil.$$$reportNull$$$0(21);
        }
        if (callback == null) {
            PyDeploymentUtil.$$$reportNull$$$0(22);
        }
        if (fileNames == null) {
            PyDeploymentUtil.$$$reportNull$$$0(23);
        }
        VirtualFile[] baseDirArr = new VirtualFile[]{baseDir};
        VirtualFile[] localFiles = fileNames.length == 0 ? baseDirArr : (VirtualFile[])Arrays.stream(fileNames).map(s -> baseDir.getFileSystem().findFileByPath(s)).filter(o -> o != null).toArray(VirtualFile[]::new);
        PublishActionUtil.uploadToDefaultServer((Project)project, (VirtualFile[])localFiles).onSuccess(it -> callback.accept(true));
    }

    static void downloadProjectFiles(@NotNull Project project, @NotNull Consumer<? super Boolean> notNullCallback, @NotNull Deployable deployable, @Nullable RemoteConnection connection, FileObject @Nullable [] remoteFiles, VirtualFile @Nullable [] localFiles) {
        if (project == null) {
            PyDeploymentUtil.$$$reportNull$$$0(24);
        }
        if (notNullCallback == null) {
            PyDeploymentUtil.$$$reportNull$$$0(25);
        }
        if (deployable == null) {
            PyDeploymentUtil.$$$reportNull$$$0(26);
        }
        IgnoreOverwritingStrategy overwritingStrategy = new IgnoreOverwritingStrategy(){

            @Nullable
            public Boolean ignoreLocalOverwriting(@NotNull FileObject target) {
                if (target == null) {
                    1.$$$reportNull$$$0(0);
                }
                return target.getName().toString().endsWith("db.sqlite3") ? Boolean.valueOf(true) : null;
            }

            @Nullable
            public Boolean ignoreRemoteOverwriting(@NotNull FileObject target) {
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "target";
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyDeploymentUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ignoreLocalOverwriting";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ignoreRemoteOverwriting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DownloadAction.download((Project)project, (Deployable)deployable, (RemoteConnection)connection, (FileObject[])remoteFiles, (VirtualFile[])localFiles, () -> notNullCallback.accept(true), (IgnoreOverwritingStrategy)overwritingStrategy);
    }

    static FileObject @NotNull [] resolveRemoteFiles(@NotNull RemoteConnection connection, String @NotNull [] fileNames) {
        if (connection == null) {
            PyDeploymentUtil.$$$reportNull$$$0(27);
        }
        if (fileNames == null) {
            PyDeploymentUtil.$$$reportNull$$$0(28);
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String name : fileNames) {
            try (FileObject fileObject = connection.resolveFile(name);){
                if (fileObject == null) continue;
                result.add(fileObject);
            }
            catch (FileSystemException e) {
                LOG.warn("Failed to get " + name, (Throwable)e);
            }
        }
        FileObject[] fileObjectArray = result.toArray(new FileObject[0]);
        if (fileObjectArray == null) {
            PyDeploymentUtil.$$$reportNull$$$0(29);
        }
        return fileObjectArray;
    }

    @Nullable
    static Pair<PathMappingSettings.PathMapping, PySshProjectSynchronizerHelpers.MyServerRootAndFolder> createMapping(@NotNull Sdk sdk, @NotNull Module module, @NotNull String serverId, @NotNull PyRemoteSdkAdditionalData additionalData) {
        if (sdk == null) {
            PyDeploymentUtil.$$$reportNull$$$0(30);
        }
        if (module == null) {
            PyDeploymentUtil.$$$reportNull$$$0(31);
        }
        if (serverId == null) {
            PyDeploymentUtil.$$$reportNull$$$0(32);
        }
        if (additionalData == null) {
            PyDeploymentUtil.$$$reportNull$$$0(33);
        }
        Project project = module.getProject();
        PySshProjectSynchronizerHelpers.MyServerRootAndFolder rootAndFolder = PySshProjectSynchronizerHelpers.getInitialServerWorkDirAndBestProjectPath(sdk, module);
        if (rootAndFolder == null) {
            return null;
        }
        String projectBasePath = PyDeploymentUtil.configurePythonPathMapping(project, serverId, rootAndFolder.getFullPath()).getLocalRoot();
        RemoteMappingsHolder mappingsHolder = new RemoteMappingsHolder(project, "python", e -> {}){

            protected void setToolTipText(String toolTipText) {
            }

            protected void setVisible(boolean visible) {
            }

            protected void setEnabled(boolean enabled) {
            }

            protected void updatePresentation(@Nullable String text) {
            }

            protected String getPresentation() {
                return null;
            }
        };
        mappingsHolder.updateServerId(serverId, (RemoteSdkAdditionalData)additionalData);
        mappingsHolder.editPathMappings();
        RemoteMappingsManager.Mappings newMappings = RemoteMappingsManager.getInstance((Project)project).getForServer("python", serverId);
        if (newMappings == null) {
            return null;
        }
        return newMappings.getSettings().stream().filter(o -> o.canReplaceLocal(projectBasePath)).findFirst().map(mapping -> Pair.create((Object)mapping, (Object)rootAndFolder)).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 19, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverId";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCredentialsTyped";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 7: 
            case 11: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyDeploymentUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappingForDeployment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullCallback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyDeploymentUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeployableUsingCredentials";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebConfig";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "configurePythonPathMapping";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRemoteFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentExist";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPythonPathMappingsForServer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDeployableUsingCredentials";
                break;
            }
            case 7: 
            case 11: 
            case 19: 
            case 29: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWebConfig";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureDeploymentForProject";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configurePythonPathMapping";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "uploadProjectFilesToDefaultServer";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "downloadProjectFiles";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveRemoteFiles";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 19, 29 -> new IllegalStateException(string);
        };
    }
}

