/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModel;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringApiVersioningMethodInspectionBase;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringEndpointVersionInspectionKt;
import com.intellij.spring.mvc.apiversioning.model.SpringApiVersioningConfiguration;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection;", "Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningMethodInspectionBase;", "<init>", "()V", "checkMethodInternal", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "module", "Lcom/intellij/openapi/module/Module;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/openapi/module/Module;Lcom/intellij/codeInspection/ProblemsHolder;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "skipNonDigits", "", "version", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringEndpointVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEndpointVersionInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,46:1\n413#2,4:47\n*S KotlinDebug\n*F\n+ 1 SpringEndpointVersionInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection\n*L\n45#1:47,4\n*E\n"})
public final class SpringEndpointVersionInspection
extends SpringApiVersioningMethodInspectionBase {
    @Override
    @NotNull
    public ProblemDescriptor[] checkMethodInternal(@NotNull UMethod uMethod, @NotNull Module module, @NotNull ProblemsHolder problemsHolder) {
        String version;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        RequestMapping.Method requestMapping = (RequestMapping.Method)JamService.getJamService((Project)module.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)uMethod.getJavaPsi());
        RequestMapping.Method method = requestMapping;
        PsiAnnotationMemberValue versionAttributeValue = method != null && (method = method.getIdentifyingAnnotation()) != null ? method.findDeclaredAttributeValue("version") : null;
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)((PsiElement)versionAttributeValue), UExpression.class);
        String string = version = uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
        if (versionAttributeValue == null || version == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SpringApiVersioningConfiguration apiVersioningConfiguration = SpringApiVersioningModel.Companion.getInstance(project).getApiVersioningConfiguration(module);
        if (apiVersioningConfiguration == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)versionAttributeValue));
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement psiElementToHighlight = uElement;
        if (StringsKt.isBlank((CharSequence)version)) {
            problemsHolder.registerProblem((PsiElement)psiElementToHighlight, SpringMvcBundle.message("mvc.api.empty.version", new Object[0]), new LocalQuickFix[0]);
        } else if (Intrinsics.areEqual((Object)apiVersioningConfiguration.getHasCustomVersionParser(), (Object)false)) {
            CharSequence charSequence = this.skipNonDigits(version);
            if (!SpringEndpointVersionInspectionKt.access$getSEM_VER_PATTERN$p().matches(charSequence)) {
                problemsHolder.registerProblem((PsiElement)psiElementToHighlight, SpringMvcBundle.message("mvc.api.sem.ver.malformed", new Object[0]), new LocalQuickFix[0]);
            }
        }
        ProblemDescriptor[] problemDescriptorArray = problemsHolder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }

    private final String skipNonDigits(String version) {
        String string;
        block1: {
            String $this$dropWhile$iv = version;
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (!Character.isDigit(it)) continue;
                String string2 = $this$dropWhile$iv.substring(index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            string = "";
        }
        return string;
    }
}

