/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.intellij.lang.xpath.xslt.quickfix.DownloadResourceFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExternalResourceReference
implements PsiReference,
LocalQuickFixProvider {
    private final XmlAttribute attribute;
    private final ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();

    ExternalResourceReference(XmlAttribute attribute) {
        this.attribute = attribute;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        return new LocalQuickFix[]{new DownloadResourceFix(this.attribute.getValue())};
    }

    @NotNull
    public PsiElement getElement() {
        XmlAttributeValue xmlAttributeValue = this.attribute.getValueElement();
        if (xmlAttributeValue == null) {
            ExternalResourceReference.$$$reportNull$$$0(0);
        }
        return xmlAttributeValue;
    }

    @NotNull
    public TextRange getRangeInElement() {
        XmlAttributeValue value = this.attribute.getValueElement();
        TextRange textRange = value != null ? TextRange.from((int)1, (int)(value.getTextLength() - 2)) : TextRange.from((int)0, (int)0);
        if (textRange == null) {
            ExternalResourceReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        VirtualFile file;
        String resourceLocation;
        String value = this.attribute.getValue();
        String string = resourceLocation = value == null ? null : this.resourceManager.getResourceLocation(value, this.attribute.getProject());
        if (Objects.equals(resourceLocation, value)) {
            return null;
        }
        try {
            file = VfsUtil.findFileByURL((URL)new URL(resourceLocation));
        }
        catch (MalformedURLException e) {
            try {
                file = VfsUtil.findFileByURL((URL)new File(resourceLocation).toURI().toURL());
            }
            catch (MalformedURLException e1) {
                file = null;
            }
        }
        if (file != null) {
            return this.attribute.getManager().findFile(file);
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.attribute.getValue();
        if (string == null) {
            ExternalResourceReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ExternalResourceReference.$$$reportNull$$$0(3);
        }
        this.attribute.setValue(newElementName);
        XmlAttributeValue value = this.attribute.getValueElement();
        assert (value != null);
        return value;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ExternalResourceReference.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ExternalResourceReference.$$$reportNull$$$0(5);
        }
        return element == this.resolve();
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.resourceManager.getResourceUrls(null, false);
        if (objectArray == null) {
            ExternalResourceReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

