/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AssociationsGroup;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

class AddAssociationAction
extends AnAction {
    private final FileAssociationsManager myManager;

    AddAssociationAction(FileAssociationsManager manager) {
        super(XPathBundle.message("action.add.association.text", new Object[0]), XPathBundle.message("action.add.file.association.description", new Object[0]), IconUtil.getAddIcon());
        this.myManager = manager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddAssociationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            AddAssociationAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = AssociationsGroup.getPsiFile(e)) == null) {
            return;
        }
        this.addAssociation(psiFile);
        DaemonCodeAnalyzer.getInstance((Project)psiFile.getProject()).restart(psiFile, (Object)this);
    }

    protected void addAssociation(PsiFile psiFile) {
        VirtualFile[] virtualFiles;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        assert (virtualFile != null);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor().withExtensionFilter(IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])new Object[]{"XML"}), FileAssociationsManager.Holder.XML_FILES).withFileFilter(file -> !file.equals(virtualFile));
        for (VirtualFile file2 : virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)psiFile.getProject(), (VirtualFile)psiFile.getVirtualFile())) {
            assert (!virtualFile.equals(file2));
            this.myManager.addAssociation(psiFile, file2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AddAssociationAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AddAssociationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

