/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.assertj.core.util.Lists;

class Services {
    private Services() {
    }

    public static <SERVICE> SERVICE get(Class<SERVICE> serviceType, SERVICE defaultValue) {
        SERVICE result;
        Iterator<SERVICE> services = ServiceLoader.load(serviceType, Services.class.getClassLoader()).iterator();
        SERVICE SERVICE = result = services.hasNext() ? services.next() : defaultValue;
        if (services.hasNext()) {
            result = defaultValue;
            System.err.printf("Found multiple implementations for the service provider %s. Using the default: %s%n", serviceType, result.getClass());
        }
        return result;
    }

    public static <SERVICE> List<SERVICE> getAll(Class<SERVICE> serviceType) {
        Iterator<SERVICE> services = ServiceLoader.load(serviceType, Services.class.getClassLoader()).iterator();
        return Lists.newArrayList(services);
    }
}

