/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalInt;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Integers;

public abstract class AbstractOptionalIntAssert<SELF extends AbstractOptionalIntAssert<SELF>>
extends AbstractAssert<SELF, OptionalInt> {
    Integers integers = Integers.instance();

    protected AbstractOptionalIntAssert(OptionalInt actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isPresent() {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }

    public SELF isNotPresent() {
        return this.isEmpty();
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalInt)this.actual));
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }

    public SELF isNotEmpty() {
        return this.isPresent();
    }

    public SELF hasValue(int expectedValue) {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalInt)this.actual).getAsInt()) {
            throw Failures.instance().failure(this.info, OptionalShouldContain.shouldContain((OptionalInt)this.actual, expectedValue), ((OptionalInt)this.actual).getAsInt(), expectedValue);
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }
}

