/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.lexer;

import com.intellij.html.embedding.HtmlEmbeddedContentProvider;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.HtmlScriptStyleEmbeddedContentProvider;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenTypes;
import org.jetbrains.vuejs.lang.html.lexer._VueLexer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002,-BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020%H\u0014J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueLexer;", "Lcom/intellij/lexer/HtmlLexer;", "languageLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "project", "Lcom/intellij/openapi/project/Project;", "interpolationConfig", "Lkotlin/Pair;", "", "htmlCompatMode", "", "highlightMode", "langMode", "Lorg/jetbrains/vuejs/lang/LangMode;", "<init>", "(Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;Lcom/intellij/openapi/project/Project;Lkotlin/Pair;ZZLorg/jetbrains/vuejs/lang/LangMode;)V", "getLanguageLevel", "()Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getInterpolationConfig", "()Lkotlin/Pair;", "getHtmlCompatMode", "()Z", "getLangMode", "()Lorg/jetbrains/vuejs/lang/LangMode;", "lexedLangMode", "getLexedLangMode", "setLexedLangMode", "(Lorg/jetbrains/vuejs/lang/LangMode;)V", "isHtmlTagState", "state", "", "acceptEmbeddedContentProvider", "provider", "Lcom/intellij/html/embedding/HtmlEmbeddedContentProvider;", "createAttributeEmbedmentTokenSet", "Lcom/intellij/psi/tree/TokenSet;", "createTagEmbedmentStartTokenSet", "isPossiblyCustomTagName", "tagName", "", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "Companion", "VueMergingLexer", "intellij.vuejs.backend"})
public final class VueLexer
extends HtmlLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSLanguageLevel languageLevel;
    @Nullable
    private final Project project;
    @Nullable
    private final Pair<String, String> interpolationConfig;
    private final boolean htmlCompatMode;
    @NotNull
    private final LangMode langMode;
    @NotNull
    private LangMode lexedLangMode;
    @NotNull
    private static final TokenSet ATTRIBUTE_TOKENS;
    @NotNull
    private static final TokenSet TAG_TOKENS;

    public VueLexer(@NotNull JSLanguageLevel languageLevel, @Nullable Project project, @Nullable Pair<String, String> interpolationConfig, boolean htmlCompatMode, boolean highlightMode, @NotNull LangMode langMode) {
        Intrinsics.checkNotNullParameter((Object)languageLevel, (String)"languageLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)langMode), (String)"langMode");
        super((Lexer)new VueMergingLexer(new FlexAdapter((FlexLexer)new _VueLexer(interpolationConfig)), highlightMode), true, highlightMode);
        this.languageLevel = languageLevel;
        this.project = project;
        this.interpolationConfig = interpolationConfig;
        this.htmlCompatMode = htmlCompatMode;
        this.langMode = langMode;
        this.lexedLangMode = LangMode.PENDING;
    }

    public /* synthetic */ VueLexer(JSLanguageLevel jSLanguageLevel, Project project, Pair pair, boolean bl, boolean bl2, LangMode langMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            langMode = LangMode.PENDING;
        }
        this(jSLanguageLevel, project, (Pair<String, String>)pair, bl, bl2, langMode);
    }

    @NotNull
    public final JSLanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Pair<String, String> getInterpolationConfig() {
        return this.interpolationConfig;
    }

    public final boolean getHtmlCompatMode() {
        return this.htmlCompatMode;
    }

    @NotNull
    public final LangMode getLangMode() {
        return this.langMode;
    }

    @NotNull
    public final LangMode getLexedLangMode() {
        return this.lexedLangMode;
    }

    public final void setLexedLangMode(@NotNull LangMode langMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)langMode), (String)"<set-?>");
        this.lexedLangMode = langMode;
    }

    protected boolean isHtmlTagState(int state2) {
        return state2 == 6 || state2 == 8;
    }

    protected boolean acceptEmbeddedContentProvider(@NotNull HtmlEmbeddedContentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return !(provider instanceof HtmlScriptStyleEmbeddedContentProvider);
    }

    @NotNull
    protected TokenSet createAttributeEmbedmentTokenSet() {
        TokenSet[] tokenSetArray = new TokenSet[]{super.createAttributeEmbedmentTokenSet(), ATTRIBUTE_TOKENS};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        return tokenSet;
    }

    @NotNull
    protected TokenSet createTagEmbedmentStartTokenSet() {
        TokenSet[] tokenSetArray = new TokenSet[]{super.createTagEmbedmentStartTokenSet(), TAG_TOKENS};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        return tokenSet;
    }

    public boolean isPossiblyCustomTagName(@NotNull CharSequence tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        return !this.htmlCompatMode && Companion.isPossiblyComponentTag(tagName);
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (this.isHighlighting() && type == XmlTokenType.TAG_WHITE_SPACE && (VueMergingLexer.Companion.getBaseLexerState(this.getState()) == 0 || VueMergingLexer.Companion.isLexerWithinUnterminatedInterpolation(this.getState()))) {
            return XmlTokenType.XML_REAL_WHITE_SPACE;
        }
        return type;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{VueTokenTypes.INTERPOLATION_START, VueTokenTypes.INTERPOLATION_EXPR, VueTokenTypes.INTERPOLATION_END};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        ATTRIBUTE_TOKENS = tokenSet;
        iElementTypeArray = new IElementType[]{VueTokenTypes.INTERPOLATION_START};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        TAG_TOKENS = tokenSet2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueLexer$Companion;", "", "<init>", "()V", "ATTRIBUTE_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getATTRIBUTE_TOKENS$intellij_vuejs_backend", "()Lcom/intellij/psi/tree/TokenSet;", "TAG_TOKENS", "getTAG_TOKENS$intellij_vuejs_backend", "isPossiblyComponentTag", "", "tagName", "", "intellij.vuejs.backend"})
    @SourceDebugExtension(value={"SMAP\nVueLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueLexer.kt\norg/jetbrains/vuejs/lang/html/lexer/VueLexer$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,140:1\n1069#2,2:141\n*S KotlinDebug\n*F\n+ 1 VueLexer.kt\norg/jetbrains/vuejs/lang/html/lexer/VueLexer$Companion\n*L\n78#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getATTRIBUTE_TOKENS$intellij_vuejs_backend() {
            return ATTRIBUTE_TOKENS;
        }

        @NotNull
        public final TokenSet getTAG_TOKENS$intellij_vuejs_backend() {
            return TAG_TOKENS;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPossiblyComponentTag(@NotNull CharSequence tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            if (tagName.length() < 3) return false;
            if (!Character.isUpperCase(tagName.charAt(0))) return false;
            CharSequence $this$all$iv = tagName;
            boolean $i$f$all = false;
            int n = 0;
            while (n < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (!Character.isUpperCase(it)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueLexer$VueMergingLexer;", "Lcom/intellij/lexer/MergingLexerAdapterBase;", "original", "Lcom/intellij/lexer/FlexAdapter;", "highlightMode", "", "<init>", "(Lcom/intellij/lexer/FlexAdapter;Z)V", "getMergeFunction", "Lcom/intellij/lexer/MergeFunction;", "merge", "Lcom/intellij/psi/tree/IElementType;", "type", "originalLexer", "Lcom/intellij/lexer/Lexer;", "Companion", "intellij.vuejs.backend"})
    private static final class VueMergingLexer
    extends MergingLexerAdapterBase {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean highlightMode;
        @NotNull
        private static final TokenSet TOKENS_TO_MERGE;

        public VueMergingLexer(@NotNull FlexAdapter original, boolean highlightMode) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            super((Lexer)original);
            this.highlightMode = highlightMode;
        }

        @NotNull
        public MergeFunction getMergeFunction() {
            return (arg_0, arg_1) -> VueMergingLexer.getMergeFunction$lambda$0(this, arg_0, arg_1);
        }

        private final IElementType merge(IElementType type, Lexer originalLexer) {
            IElementType tokenType = type;
            IElementType next = originalLexer.getTokenType();
            if (tokenType == VueTokenTypes.INTERPOLATION_START && next != VueTokenTypes.INTERPOLATION_EXPR && next != VueTokenTypes.INTERPOLATION_END) {
                IElementType iElementType = tokenType = next == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || next == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN : XmlTokenType.XML_DATA_CHARACTERS;
            }
            if (TOKENS_TO_MERGE.contains(tokenType)) {
                IElementType nextTokenType;
                while ((nextTokenType = originalLexer.getTokenType()) == tokenType) {
                    originalLexer.advance();
                }
            }
            if (this.highlightMode && tokenType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                while (originalLexer.getTokenType() == XmlTokenType.XML_CHAR_ENTITY_REF) {
                    originalLexer.advance();
                }
                if (originalLexer.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
                }
            }
            return tokenType;
        }

        private static final IElementType getMergeFunction$lambda$0(VueMergingLexer this$0, IElementType type, Lexer originalLexer) {
            Intrinsics.checkNotNull((Object)originalLexer);
            return this$0.merge(type, originalLexer);
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_TAG_CHARACTERS};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            TOKENS_TO_MERGE = tokenSet;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueLexer$VueMergingLexer$Companion;", "", "<init>", "()V", "TOKENS_TO_MERGE", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "isLexerWithinUnterminatedInterpolation", "", "state", "", "getBaseLexerState", "intellij.vuejs.backend"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isLexerWithinUnterminatedInterpolation(int state2) {
                return this.getBaseLexerState(state2) == 30;
            }

            public final int getBaseLexerState(int state2) {
                return state2 & 0x3F;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

