/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ReadOnlyGenericValue;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotationGenericValue<T>
extends ReadOnlyGenericValue<T> {
    public static final AnnotationGenericValue NULL = AnnotationGenericValue.getInstanceInternal(null, null, null);

    public abstract PsiAnnotation getIdentifyingAnnotation();

    public abstract PsiElement getDefiningElement();

    public static <T> AnnotationGenericValue<T> nullInstance() {
        return NULL;
    }

    public static <T> AnnotationGenericValue<T> getInstance(@Nullable T value, PsiAnnotation annotation, PsiElement definingElement) {
        return value == null && annotation == null ? NULL : AnnotationGenericValue.getInstanceInternal(value, annotation, definingElement);
    }

    private static <T> AnnotationGenericValue<T> getInstanceInternal(final T value, final PsiAnnotation annotation, final PsiElement definingElement) {
        return new AnnotationGenericValue<T>(){

            @Override
            public PsiAnnotation getIdentifyingAnnotation() {
                return annotation;
            }

            @Override
            public PsiElement getDefiningElement() {
                return definingElement;
            }

            public T getValue() {
                return value;
            }

            public String getStringValue() {
                if (value != null) {
                    if (value instanceof PsiClass) {
                        return ((PsiClass)value).getQualifiedName();
                    }
                    return String.valueOf(value);
                }
                if (definingElement != null) {
                    if (definingElement instanceof PsiClassObjectAccessExpression) {
                        return ((PsiClassObjectAccessExpression)definingElement).getOperand().getType().getCanonicalText();
                    }
                    Object o = JamCommonUtil.computeMemberValue((PsiElement)definingElement);
                    if (o instanceof String) {
                        return (String)o;
                    }
                    return definingElement.getText();
                }
                return null;
            }
        };
    }
}

