/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DefaultTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.util.LobInfoHelper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DbTextEditorFactory
extends DefaultTextEditorFactory
implements FactoryWithDomainSupport {
    private static final Set<String> PG_EDITABLE = Set.of("uuid", "inet", "cidr", "macaddr", "interval", "money", "citext", "ltree");
    private static final Set<String> CASS_EDITABLE = Set.of("set", "map", "list", "tuple", "udt", "uuid", "timeuuid", "inet");

    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DbTextEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DbTextEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DbTextEditorFactory.$$$reportNull$$$0(2);
        }
        if (grid.getDataHookup() instanceof DocumentDataHookUp) {
            return 10;
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn c2 = Objects.requireNonNull((GridColumn)model.getColumn(column));
        int suitability = 0;
        Dbms dbms = DataGridUtil.getDbms(grid);
        if (dbms.in(Dbms.POSTGRES_LIKE)) {
            suitability = DbTextEditorFactory.getPostgresSuitability(c2);
        } else if (dbms.is(Dbms.CASSANDRA)) {
            suitability = DbTextEditorFactory.getCassandraSuitability(c2);
        } else if (dbms.is(Dbms.H2)) {
            suitability = DbTextEditorFactory.getH2Suitability(c2);
        }
        return suitability != 0 ? suitability : super.getSuitability(grid, row, column);
    }

    private static int getPostgresSuitability(@NotNull GridColumn c2) {
        if (c2 == null) {
            DbTextEditorFactory.$$$reportNull$$$0(3);
        }
        return switch (c2.getType()) {
            case 0, 1111 -> {
                String typeName = c2.getTypeName();
                if (typeName != null && (PG_EDITABLE.contains(typeName) || PgBaseJdbcHelper.isEditableType((String)typeName, (int)c2.getType()))) {
                    yield 1;
                }
                yield 0;
            }
            case 2002, 2003 -> 1;
            default -> 0;
        };
    }

    private static int getCassandraSuitability(@NotNull GridColumn c2) {
        String typeName;
        if (c2 == null) {
            DbTextEditorFactory.$$$reportNull$$$0(4);
        }
        int index = (typeName = c2.getTypeName()) == null ? -1 : typeName.indexOf("(");
        String simplifiedTypeName = index == -1 ? typeName : typeName.substring(0, index);
        return CASS_EDITABLE.contains(StringUtil.toLowerCase((String)simplifiedTypeName)) ? 1 : 0;
    }

    private static int getH2Suitability(@NotNull GridColumn c2) {
        if (c2 == null) {
            DbTextEditorFactory.$$$reportNull$$$0(5);
        }
        return "enum".equals(StringUtil.toLowerCase((String)c2.getTypeName())) ? 1 : 0;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DbTextEditorFactory.$$$reportNull$$$0(6);
        }
        if (domain == null) {
            DbTextEditorFactory.$$$reportNull$$$0(7);
        }
        return LogicalType.isText((LogicalType)domain.getLogicType()) ? 1 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DbTextEditorFactory.$$$reportNull$$$0(8);
        }
        if (domain == null) {
            DbTextEditorFactory.$$$reportNull$$$0(9);
        }
        GridCellEditorFactory.ValueParser valueParser = (text, document) -> text;
        if (valueParser == null) {
            DbTextEditorFactory.$$$reportNull$$$0(10);
        }
        return valueParser;
    }

    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (value, grid, column) -> {
            Dbms dbms = DataGridUtil.getDbms(grid);
            if (DbTextEditorFactory.isEditable((Object)value)) {
                return true;
            }
            if (dbms.in(Dbms.POSTGRES_LIKE)) {
                Object[] objArray;
                return value instanceof Object[] && (objArray = (Object[])value).length < LobInfoHelper.MAX_ARRAY_SIZE;
            }
            if (dbms.is(Dbms.CASSANDRA)) {
                return value instanceof Map || value instanceof Set || value instanceof List;
            }
            if (dbms.is(Dbms.MONGO)) {
                return value instanceof Map || value instanceof List;
            }
            return false;
        };
        if (isEditableChecker == null) {
            DbTextEditorFactory.$$$reportNull$$$0(11);
        }
        return isEditableChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DbTextEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DbTextEditorFactory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPostgresSuitability";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCassandraSuitability";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getH2Suitability";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

