/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObjectsGoToContributorBase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.pom.Navigatable;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public class DbObjectsGoToContributor
extends DbObjectsGoToContributorBase {
    @Override
    protected boolean processNamesInDataSource(@NotNull DbDataSource ds, @NotNull Processor<? super String> processor) {
        if (ds == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(1);
        }
        if (!super.processNamesInDataSource(ds, processor)) {
            return false;
        }
        return DbObjectsGoToContributor.getVirtualViewNames(ds).processEach(processor);
    }

    @NotNull
    private static JBIterable<String> getVirtualViewNames(@NotNull DbDataSource ds) {
        LocalDataSource lds;
        if (ds == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(2);
        }
        if ((lds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)ds)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbObjectsGoToContributor.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = ModelExternalData.getInstance().getDataSourceData(lds, false).flatten(d -> d.objSet.values()).filter(ModelExternalData.ViewDesc.class).map(v -> v.name);
        if (jBIterable == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    protected Iterable<DasObject> getObjectsByNameInDataSource(@NotNull DbDataSource dataSource, @NotNull String name) {
        if (dataSource == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(5);
        }
        if (name == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(6);
        }
        Iterable<DasObject> objects = super.getObjectsByNameInDataSource(dataSource, name);
        JBIterable jBIterable = DbObjectsGoToContributor.getAllVirtualViewsInDataSource(dataSource, name).append(objects);
        if (jBIterable == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getAllVirtualViewsInDataSource(@NotNull DbDataSource dataSource, @NotNull String name) {
        BasicModel model;
        if (dataSource == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(8);
        }
        if (name == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(9);
        }
        if ((model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class)) == null || !DbObjectsGoToContributor.getVirtualViewNames(dataSource).contains((Object)name)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbObjectsGoToContributor.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        DatabaseCoreUiService us = DatabaseCoreUiService.getInstance();
        JBIterable jBIterable = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)model.getRoot())), (TreePattern)DbImplUtilCore.getIntrospectionScope((DasDataSource)dataSource)).expandAndFilter(o -> o instanceof BasicRoot || o instanceof BasicNamespace)).traverse().filter(BasicElement.class).flatten(n -> DbObjectsGoToContributor.getVirtualViewsIn(us, dataSource, n, name));
        if (jBIterable == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getVirtualViewsIn(@NotNull DatabaseCoreUiService uiService, @NotNull DbDataSource dataSource, @NotNull BasicElement namespace, @NotNull String name) {
        if (uiService == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(12);
        }
        if (dataSource == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(13);
        }
        if (namespace == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(14);
        }
        if (name == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(15);
        }
        if (!DbObjectsGoToContributor.hasVirtualViewsWithName(dataSource, namespace, name)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbObjectsGoToContributor.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        JBIterable jBIterable = uiService.treeChildren(dataSource.getProject(), (Object)namespace, DvFamilyId.VIRTUAL_VIEW.getFakeKind()).filter(DasObject.class);
        if (jBIterable == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    private static boolean hasVirtualViewsWithName(@NotNull DbDataSource dataSource, @NotNull BasicElement namespace, @NotNull String name) {
        LocalDataSource lds;
        if (dataSource == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(18);
        }
        if (namespace == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(19);
        }
        if (name == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(20);
        }
        if ((lds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource)) == null) {
            return false;
        }
        BasicMetaObject vvMeta = (BasicMetaObject)ContainerUtil.find((Iterable)VmModelContextFactory.createContextVmMetaObjects((BasicMetaObject)namespace.getMetaObject()), m -> m.kind == DvFamilyId.VIRTUAL_VIEW.getFakeKind());
        if (vvMeta == null) {
            return false;
        }
        VmModelContextFactory.VmExtractor extractor = VmModelContextFactory.createVirtualObjectsExtractor((BasicMetaObject)vvMeta);
        if (extractor == null) {
            return false;
        }
        return extractor.extractData(lds, namespace).filter(ModelExternalData.ViewDesc.class).filter(vd -> vd.name.equals(name)).isNotEmpty();
    }

    @Override
    @Nullable
    protected NavigationItem getNavigationItem(DbDataSource dataSource, DasObject o) {
        NavigationItem item = super.getNavigationItem(dataSource, o);
        DbElement element = item == null ? null : DbNavigationUtils.extractDbElement((Navigatable)item);
        return element == null ? item : DbNavigationUtils.createFromTreeNavigatable(element);
    }

    @NotNull
    public String getElementKind() {
        String string = DatabaseBundle.message((String)"go.to.table.kind.text", (Object[])new Object[0]);
        if (string == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public List<String> getElementKindsPluralized() {
        List<String> list = List.of(DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.tables", (Object[])new Object[0]), DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.views", (Object[])new Object[0]), DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.routines", (Object[])new Object[0]));
        if (list == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public String getTabTitlePluralized() {
        String string = DatabaseBundle.message((String)"go.to.table.title", (Object[])new Object[0]);
        if (string == null) {
            DbObjectsGoToContributor.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public Language getElementLanguage() {
        return SqlLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 10, 11, 16, 17, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbObjectsGoToContributor";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiService";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbObjectsGoToContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualViewNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInDataSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVirtualViewsInDataSource";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualViewsIn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKind";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKindsPluralized";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitlePluralized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNamesInDataSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualViewNames";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInDataSource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllVirtualViewsInDataSource";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualViewsIn";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasVirtualViewsWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 10, 11, 16, 17, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

